/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.pluginpersewaan.bl;

import com.bits.bee.bl.BLConst;
import com.bits.bee.bl.BLUtil;
import com.bits.bee.bl.ItemExplode;
import com.bits.bee.bl.ItemList;
import com.bits.bee.bl.QtyExplode;
import com.bits.bee.bl.Tax;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BTrans;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import java.math.BigDecimal;
import java.math.MathContext;

public class TransactionCalculatorBooking {
    public static final String PURC = "PURC";
    public static final String PO = "PO";
    public static final String SALE = "SALE";
    public static final String DELI = "DELI";

    public void discCalc(DataSet ds) {
        if (ds.getRowCount() != 0) {
            if (!ds.isNull("discexp") && ds.getString("discexp").length() > 0) {
                ds.setBigDecimal("discamt", BLUtil.setScaling((BigDecimal)BHelp.EvalDiscExp((BigDecimal)ds.getBigDecimal("listprice"), (String)ds.getString("discexp"))));
            } else {
                ds.setBigDecimal("discamt", BigDecimal.ZERO);
            }
        }
    }

    public void taxCalc(DataSet ds) {
        this.taxCalc(ds, false);
    }

    public void taxCalc(DataSet ds, boolean taxInc) {
        String itemid = ds.getString("itemid");
        MathContext mc = BLUtil.MC_FOUR;
        if (ds.getRowCount() != 0) {
            if (!ds.isNull("taxid")) {
                String taxid = ItemList.getInstance().getPurcTaxID(itemid);
                String taxexp = Tax.getInstance().getTaxExp(ds.getString("taxid"));
                BigDecimal TaxPcn = BHelp.EvalDiscExp((BigDecimal)new BigDecimal(1), (String)taxexp).multiply(BLConst.HUNDRED, mc);
                BigDecimal nettprice = ds.getBigDecimal("listprice").subtract(ds.getBigDecimal("discamt"), mc).subtract(ds.getBigDecimal("disc2amt"), mc);
                BigDecimal pembilang = TaxPcn;
                BigDecimal penyebut = taxInc ? BLConst.HUNDRED.add(TaxPcn, mc) : BLConst.HUNDRED;
                BigDecimal taxamt = nettprice.multiply(pembilang.divide(penyebut, mc));
                ds.setString("taxid", taxid);
                ds.setBigDecimal("taxamt", taxamt);
            } else {
                ds.setBigDecimal("taxamt", BigDecimal.ZERO);
            }
        }
    }

    public ItemExplode itemExplode(DataSet ds, String type, BigDecimal qtyDue, BigDecimal price, boolean split_qty) {
        ItemExplode itemexp = new ItemExplode();
        QtyExplode qtyexplode = null;
        MathContext mc = BLUtil.MC_FOUR;
        String itemid = ds.getString("itemid");
        qtyexplode = ItemList.getInstance().getQtyExplode(ds.getString("itemid"), qtyDue);
        DataRow row = new DataRow(itemexp.getDataSet());
        if (split_qty) {
            for (int j = 1; j <= 3; ++j) {
                boolean satu = false;
                boolean dua = false;
                boolean tiga = false;
                if (j == 1) {
                    if (qtyexplode.getQty1().compareTo(BigDecimal.ZERO) == 0) continue;
                    satu = true;
                }
                if (j == 2) {
                    if (qtyexplode.getQty2().compareTo(BigDecimal.ZERO) == 0) continue;
                    dua = true;
                }
                if (j == 3) {
                    if (qtyexplode.getQty3().compareTo(BigDecimal.ZERO) == 0) continue;
                    tiga = true;
                }
                if (satu) {
                    row.setString("itemid", itemid);
                    row.setBigDecimal("qty", qtyexplode.getQty1());
                    row.setString("unit", ItemList.getInstance().getUnit1(itemid));
                    row.setBigDecimal("price", price);
                }
                if (dua) {
                    row.setString("itemid", itemid);
                    row.setBigDecimal("qty", qtyexplode.getQty2());
                    row.setString("unit", ItemList.getInstance().getUnit2(itemid));
                    row.setBigDecimal("price", price.multiply(ItemList.getInstance().getConv2(itemid), mc));
                }
                if (tiga) {
                    row.setString("itemid", itemid);
                    row.setBigDecimal("qty", qtyexplode.getQty3());
                    row.setString("unit", ItemList.getInstance().getUnit3(itemid));
                    row.setBigDecimal("price", price.multiply(ItemList.getInstance().getConv3(itemid), mc));
                }
                itemexp.getDataSet().addRow(row);
            }
        } else if (qtyDue.compareTo(BigDecimal.ZERO) != 0) {
            itemexp.getDataSet().setString("itemid", itemid);
            itemexp.getDataSet().setBigDecimal("qty", qtyDue);
            itemexp.getDataSet().setString("unit", ds.getString("unit"));
            itemexp.getDataSet().setBigDecimal("price", price);
        }
        return itemexp;
    }

    public void calcDetailBaseprice(DataSet dataSet, boolean taxInc) {
        BigDecimal basePrice;
        BigDecimal seratus = new BigDecimal(100);
        if (taxInc) {
            String taxexp = Tax.getInstance().getTaxExp(dataSet.getString("taxid"));
            BigDecimal TaxPcn = BHelp.EvalDiscExp((BigDecimal)BigDecimal.ONE, (String)taxexp).multiply(seratus);
            BigDecimal penyebut = seratus.add(TaxPcn);
            BigDecimal discamt = dataSet.getBigDecimal("discamt");
            BigDecimal hargaDisc = dataSet.getBigDecimal("listprice").subtract(discamt);
            basePrice = discamt.add(hargaDisc.multiply(seratus.divide(penyebut, BLUtil.MC_FOUR)));
        } else {
            basePrice = dataSet.getBigDecimal("listprice");
        }
        dataSet.setBigDecimal("baseprice", basePrice);
    }

    public void calcDetailDisc(DataSet ds) {
        if (!ds.isNull("discexp") && ds.getString("discexp").length() > 0) {
            ds.setBigDecimal("discamt", BLUtil.setScaling((BigDecimal)BHelp.EvalDiscExp((BigDecimal)ds.getBigDecimal("listprice"), (String)ds.getString("discexp"))));
            ds.setBigDecimal("totaldiscamt", BLUtil.setScaling((BigDecimal)ds.getBigDecimal("discamt").multiply(ds.getBigDecimal("qty").multiply(ds.getBigDecimal("qtyday")))));
        } else {
            ds.setBigDecimal("totaldiscamt", BigDecimal.ZERO);
            ds.setBigDecimal("discamt", BigDecimal.ZERO);
        }
    }

    public void calcDetailConsDisc(DataSet ds) {
        if (!ds.isNull("discexp") && ds.getString("discexp").length() > 0) {
            ds.setBigDecimal("discamt", BLUtil.setScaling((BigDecimal)BHelp.EvalDiscExp((BigDecimal)ds.getBigDecimal("listprice"), (String)ds.getString("discexp"))));
            ds.setBigDecimal("totaldiscamt", BLUtil.setScaling((BigDecimal)ds.getBigDecimal("discamt").multiply(ds.getBigDecimal("qtysellin"))));
        } else {
            ds.setBigDecimal("totaldiscamt", BigDecimal.ZERO);
            ds.setBigDecimal("discamt", BigDecimal.ZERO);
        }
    }

    public void calcDetailTax(DataSet ds, boolean taxInc, BigDecimal fisRate, BigDecimal excRate) {
        BigDecimal TaxPcn = BigDecimal.ZERO;
        BigDecimal nettprice = BigDecimal.ZERO;
        BigDecimal penyebut = BigDecimal.ZERO;
        String itemid = ds.getString("itemid");
        String taxid = null;
        String taxexp = null;
        MathContext mc = BLUtil.MC_FOUR;
        if (ds.getRowCount() != 0) {
            if (!ds.isNull("taxid")) {
                taxid = ItemList.getInstance().getPurcTaxID(itemid);
                taxexp = Tax.getInstance().getTaxExp(ds.getString("taxid"));
                BigDecimal pembilang = TaxPcn = BHelp.EvalDiscExp((BigDecimal)new BigDecimal(1), (String)taxexp).multiply(BLConst.HUNDRED, mc);
                penyebut = taxInc ? BLConst.HUNDRED.add(TaxPcn, mc) : BLConst.HUNDRED;
                nettprice = ds.getBigDecimal("listprice").subtract(ds.getBigDecimal("discamt")).multiply(ds.getBigDecimal("qty"), BLUtil.MC_FOUR).multiply(ds.getBigDecimal("qtyday"), BLUtil.MC_FOUR);
                BigDecimal taxableamt = nettprice.divide(penyebut, mc).multiply(BLConst.HUNDRED, mc).subtract(ds.getBigDecimal("totaldisc2amt"));
                penyebut = BLConst.HUNDRED;
                BigDecimal taxamt = taxableamt.multiply(pembilang.divide(penyebut, mc));
                taxamt = BLUtil.setScaling((BigDecimal)taxamt);
                ds.setBigDecimal("totaltaxamt", BLUtil.setScalingTax((BigDecimal)taxamt));
                ds.setBigDecimal("basftotaltaxamt", BLUtil.setScalingBaseTax((BigDecimal)ds.getBigDecimal("totaltaxamt").multiply(fisRate, BLUtil.MC_FOUR)));
                ds.setBigDecimal("basetotaltaxamt", BLUtil.setScalingBaseTax((BigDecimal)ds.getBigDecimal("totaltaxamt").multiply(excRate, BLUtil.MC_FOUR)));
                ds.setBigDecimal("taxableamt", taxableamt);
                ds.setBigDecimal("taxamt", taxamt.divide(ds.getBigDecimal("qty"), BLUtil.MC_FOUR));
            } else {
                ds.setBigDecimal("totaltaxamt", BigDecimal.ZERO);
                ds.setBigDecimal("basftotaltaxamt", BigDecimal.ZERO);
                ds.setBigDecimal("basetotaltaxamt", BigDecimal.ZERO);
                ds.setBigDecimal("taxableamt", BigDecimal.ZERO);
                ds.setBigDecimal("taxamt", BigDecimal.ZERO);
            }
        }
    }

    public void calcDetailConsTax(DataSet ds, boolean taxInc, BigDecimal fisRate, BigDecimal excRate) {
        BigDecimal TaxPcn = BigDecimal.ZERO;
        BigDecimal nettprice = BigDecimal.ZERO;
        BigDecimal penyebut = BigDecimal.ZERO;
        String itemid = ds.getString("itemid");
        String taxid = null;
        String taxexp = null;
        MathContext mc = BLUtil.MC_FOUR;
        if (ds.getRowCount() != 0) {
            if (!ds.isNull("taxid")) {
                taxid = ItemList.getInstance().getPurcTaxID(itemid);
                taxexp = Tax.getInstance().getTaxExp(ds.getString("taxid"));
                BigDecimal pembilang = TaxPcn = BHelp.EvalDiscExp((BigDecimal)new BigDecimal(1), (String)taxexp).multiply(BLConst.HUNDRED, mc);
                penyebut = taxInc ? BLConst.HUNDRED.add(TaxPcn, mc) : BLConst.HUNDRED;
                nettprice = ds.getBigDecimal("listprice").subtract(ds.getBigDecimal("discamt")).multiply(ds.getBigDecimal("qtysellin"), BLUtil.MC_FOUR);
                BigDecimal taxableamt = nettprice.divide(penyebut, mc).multiply(BLConst.HUNDRED, mc).subtract(ds.getBigDecimal("totaldisc2amt"));
                penyebut = BLConst.HUNDRED;
                BigDecimal taxamt = taxableamt.multiply(pembilang.divide(penyebut, mc));
                taxamt = BLUtil.setScaling((BigDecimal)taxamt);
                ds.setBigDecimal("totaltaxamt", BLUtil.setScalingTax((BigDecimal)taxamt));
                ds.setBigDecimal("basftotaltaxamt", BLUtil.setScalingBaseTax((BigDecimal)ds.getBigDecimal("totaltaxamt").multiply(fisRate, BLUtil.MC_FOUR)));
                ds.setBigDecimal("basetotaltaxamt", BLUtil.setScalingBaseTax((BigDecimal)ds.getBigDecimal("totaltaxamt").multiply(excRate, BLUtil.MC_FOUR)));
                ds.setBigDecimal("taxableamt", taxableamt);
                ds.setBigDecimal("taxamt", taxamt.divide(ds.getBigDecimal("qtysellin"), BLUtil.MC_FOUR));
            } else {
                ds.setBigDecimal("totaltaxamt", BigDecimal.ZERO);
                ds.setBigDecimal("basftotaltaxamt", BigDecimal.ZERO);
                ds.setBigDecimal("basetotaltaxamt", BigDecimal.ZERO);
                ds.setBigDecimal("taxableamt", BigDecimal.ZERO);
                ds.setBigDecimal("taxamt", BigDecimal.ZERO);
            }
        }
    }

    public void calcDetailFATax(DataSet ds, boolean taxInc, BigDecimal fisRate, BigDecimal excRate) {
        BigDecimal TaxPcn = BigDecimal.ZERO;
        BigDecimal nettprice = BigDecimal.ZERO;
        BigDecimal penyebut = BigDecimal.ZERO;
        String faid = ds.getString("faid");
        String taxid = null;
        String taxexp = null;
        MathContext mc = BLUtil.MC_FOUR;
        if (ds.getRowCount() != 0) {
            if (!ds.isNull("taxid")) {
                taxid = ItemList.getInstance().getPurcTaxID(faid);
                taxexp = Tax.getInstance().getTaxExp(ds.getString("taxid"));
                BigDecimal pembilang = TaxPcn = BHelp.EvalDiscExp((BigDecimal)new BigDecimal(1), (String)taxexp).multiply(BLConst.HUNDRED, mc);
                penyebut = taxInc ? BLConst.HUNDRED.add(TaxPcn, mc) : BLConst.HUNDRED;
                nettprice = ds.getBigDecimal("listprice").subtract(ds.getBigDecimal("discamt")).multiply(ds.getBigDecimal("qty"), BLUtil.MC_FOUR);
                BigDecimal taxableamt = nettprice.divide(penyebut, mc).multiply(BLConst.HUNDRED, mc).subtract(ds.getBigDecimal("totaldisc2amt"));
                penyebut = BLConst.HUNDRED;
                BigDecimal taxamt = taxableamt.multiply(pembilang.divide(penyebut, mc));
                taxamt = BLUtil.setScaling((BigDecimal)taxamt);
                ds.setBigDecimal("totaltaxamt", BLUtil.setScalingTax((BigDecimal)taxamt));
                ds.setBigDecimal("basftotaltaxamt", BLUtil.setScalingBaseTax((BigDecimal)ds.getBigDecimal("totaltaxamt").multiply(fisRate, BLUtil.MC_FOUR)));
                ds.setBigDecimal("basetotaltaxamt", BLUtil.setScalingBaseTax((BigDecimal)ds.getBigDecimal("totaltaxamt").multiply(excRate, BLUtil.MC_FOUR)));
                ds.setBigDecimal("taxableamt", taxableamt);
                ds.setBigDecimal("taxamt", taxamt.divide(ds.getBigDecimal("qty"), BLUtil.MC_FOUR));
            } else {
                ds.setBigDecimal("totaltaxamt", BigDecimal.ZERO);
                ds.setBigDecimal("basftotaltaxamt", BigDecimal.ZERO);
                ds.setBigDecimal("basetotaltaxamt", BigDecimal.ZERO);
                ds.setBigDecimal("taxableamt", BigDecimal.ZERO);
                ds.setBigDecimal("taxamt", BigDecimal.ZERO);
            }
        }
    }

    public void calcDetailSubtotal(DataSet dataSet) {
        this.calcDetailSubtotal(dataSet, BigDecimal.ONE);
    }

    public void calcDetailSubtotal(DataSet dataSet, BigDecimal excRate) {
        dataSet.setBigDecimal("subtotal", BLUtil.setScaling((BigDecimal)dataSet.getBigDecimal("qty").multiply(dataSet.getBigDecimal("qtyday")).multiply(dataSet.getBigDecimal("baseprice").subtract(dataSet.getBigDecimal("discamt")))));
        dataSet.setBigDecimal("basesubtotal", BLUtil.setScaling((BigDecimal)dataSet.getBigDecimal("subtotal").multiply(excRate, BLUtil.MC_FOUR)));
    }

    public void calcDetailConsSubtotal(DataSet dataSet, BigDecimal excRate) {
        dataSet.setBigDecimal("subtotal", BLUtil.setScaling((BigDecimal)dataSet.getBigDecimal("qtysellin").multiply(dataSet.getBigDecimal("baseprice").subtract(dataSet.getBigDecimal("discamt")))));
        dataSet.setBigDecimal("basesubtotal", BLUtil.setScaling((BigDecimal)dataSet.getBigDecimal("subtotal").multiply(excRate, BLUtil.MC_FOUR)));
    }

    public void updateMasterTotal(DataSet dataSet, BigDecimal oldValue, BigDecimal newValue) {
        if (oldValue == null) {
            oldValue = BigDecimal.ZERO;
        }
        if (newValue == null) {
            newValue = BigDecimal.ZERO;
        }
        dataSet.setBigDecimal("subtotal", dataSet.getBigDecimal("subtotal").subtract(oldValue).add(newValue));
    }

    public void updateMasterBaseTotal(DataSet dataSet, BigDecimal oldValue, BigDecimal newValue) {
        if (oldValue == null) {
            oldValue = BigDecimal.ZERO;
        }
        if (newValue == null) {
            newValue = BigDecimal.ZERO;
        }
        dataSet.setBigDecimal("basesubtotal", dataSet.getBigDecimal("basesubtotal").subtract(oldValue).add(newValue));
    }

    public void updateMasterTax(DataSet dataSet, BigDecimal oldValue, BigDecimal newValue) {
        if (oldValue == null) {
            oldValue = BigDecimal.ZERO;
        }
        if (newValue == null) {
            newValue = BigDecimal.ZERO;
        }
        dataSet.setBigDecimal("taxamt", dataSet.getBigDecimal("taxamt").subtract(oldValue).add(newValue));
    }

    public void updateMasterBaseFTax(DataSet dataSet, BigDecimal oldValue, BigDecimal newValue) {
        if (oldValue == null) {
            oldValue = BigDecimal.ZERO;
        }
        if (newValue == null) {
            newValue = BigDecimal.ZERO;
        }
        dataSet.setBigDecimal("basftaxamt", dataSet.getBigDecimal("basftaxamt").subtract(oldValue).add(newValue));
    }

    public void updateMasterBaseTax(DataSet dataSet, BigDecimal oldValue, BigDecimal newValue) {
        if (oldValue == null) {
            oldValue = BigDecimal.ZERO;
        }
        if (newValue == null) {
            newValue = BigDecimal.ZERO;
        }
        dataSet.setBigDecimal("basetaxamt", dataSet.getBigDecimal("basetaxamt").subtract(oldValue).add(newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal sumDetail(BTrans trans, DataSet dataSet, String columnName) {
        BigDecimal retval = BigDecimal.ZERO;
        int bookmark = dataSet.getRow();
        try {
            trans.setBypass(true);
            trans.enableDataSetEvents(false);
            int rowCount = dataSet.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                dataSet.goToRow(i);
                retval = retval.add(dataSet.getBigDecimal(columnName));
            }
        }
        finally {
            trans.enableDataSetEvents(true);
            dataSet.goToRow(bookmark);
            trans.setBypass(false);
        }
        return retval;
    }

    public BigDecimal getPriceWithTax(BigDecimal listPrice, String taxid) {
        BigDecimal retval = listPrice;
        if ("PPN".equals(taxid)) {
            BigDecimal TaxPcn;
            String taxexp = Tax.getInstance().getTaxExp(taxid);
            MathContext mc = BLUtil.MC_FOUR;
            BigDecimal pembilang = TaxPcn = BHelp.EvalDiscExp((BigDecimal)new BigDecimal(1), (String)taxexp).multiply(BLConst.HUNDRED, mc);
            BigDecimal penyebut = BLConst.HUNDRED;
            retval = listPrice.add(listPrice.multiply(pembilang.divide(penyebut, mc), mc));
        }
        return retval;
    }

    public BigDecimal getPriceBeforeTax(BigDecimal taxincPrice, String taxid) {
        BigDecimal retval = taxincPrice;
        if ("PPN".equals(taxid)) {
            String taxexp = Tax.getInstance().getTaxExp(taxid);
            MathContext mc = BLUtil.MC_FOUR;
            BigDecimal TaxPcn = BHelp.EvalDiscExp((BigDecimal)new BigDecimal(1), (String)taxexp).multiply(BLConst.HUNDRED, mc);
            BigDecimal penyebut = BLConst.HUNDRED;
            BigDecimal pembilang = BLConst.HUNDRED.add(TaxPcn, mc);
            retval = taxincPrice.divide(pembilang.divide(penyebut, mc), mc);
        }
        return retval;
    }
}

