/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.pluginpersewaan.ui.dlg;

import com.bits.bee.bl.Cmp;
import com.bits.bee.bl.InstanceObserver;
import com.bits.bee.bl.Item;
import com.bits.bee.bl.ItemList;
import com.bits.bee.bl.Pid;
import com.bits.bee.bl.Price;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.Stock;
import com.bits.bee.bl.constants.ObjConstants;
import com.bits.bee.bl.list.factory.IPriceList;
import com.bits.bee.bl.list.factory.IPriceListFactory;
import com.bits.bee.conf.InstanceMgr;
import com.bits.bee.confui.ConfMgr;
import com.bits.bee.ui.CurrencyGetter;
import com.bits.bee.ui.DlgSearchItemPID;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.myswing.BtnCancel;
import com.bits.bee.ui.myswing.BtnOK;
import com.bits.bee.ui.myswing.ComponentResources;
import com.bits.bee.ui.myswing.JCboWh;
import com.bits.bee.ui.myswing.JTextBCode;
import com.bits.bee.ui.myswing.PikItem;
import com.bits.lib.BHelp;
import com.bits.lib.dbswing.JBComboBox;
import com.bits.lib.dbswing.JBDialog;
import com.bits.lib.dbswing.JBPicker;
import com.bits.lib.dbswing.JBStatusbarDialog;
import com.bits.lib.dbswing.JBToolbarDialog;
import com.bits.lib.dbswing.JBToolbarEvent;
import com.bits.lib.dbswing.JBToolbarListener;
import com.bits.lib.dbswing.JBdbTable;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BTrans;
import com.bits.lib.dx.JBSQL;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.bits.lib.security.BAuthMgr;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import org.openide.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgSearchItemPIDRental
extends JBDialog
implements InstanceObserver,
ResourceGetter,
ObjConstants,
NavigationListener {
    private static Logger logger = LoggerFactory.getLogger(DlgSearchItemPID.class);
    private Pid pid = new Pid();
    private String custid;
    private String itemid;
    private String stringPID;
    public String fromTrans;
    public String query = "select s.whid,whname,s.itemid,itemdesc,s.pid,s.avgcost,fQty1Desc(s.itemid,s.qty) as qtyunit FROM stockrent s JOIN item i ON i.itemid=s.itemid JOIN wh ON wh.whid=s.whid ";
    private boolean STOCK_ENABLED = BAuthMgr.getDefault().getAuth("516001", "ENB");
    private QueryDataSet qds = new QueryDataSet();
    private StringBuffer sql = new StringBuffer();
    private StringBuffer filter = new StringBuffer();
    private DataSetView dsv = new DataSetView();
    private static DlgSearchItemPIDRental singleton = null;
    private DataSet lastds = null;
    private CurrencyGetter currencyGetter;
    private String crcid;
    private String whid;
    private BTrans trans;
    private boolean useDefaWHID = true;
    private boolean bypass = false;
    private BigDecimal price = BigDecimal.ZERO;
    private String discexp = null;
    private LocaleInstance l = LocaleInstance.getInstance();
    private boolean usePrice = true;
    private final IPriceList iPriceList = IPriceListFactory.getInstance().getIPriceList();
    private BtnCancel btnCancel1;
    private BtnOK btnOK1;
    private JBStatusbarDialog jBStatusbarDialog1;
    private JBToolbarDialog jBToolbarDialog1;
    private JBdbTable jBdbTable1;
    private JCboWh jCboWh1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTextBCode pidno;
    private PikItem pikItem1;

    public DlgSearchItemPIDRental() {
        super((Frame)ScreenManager.getParent(), "Cari Item PID");
        this.pid.getDataSet().emptyAllRows();
        this.initComponents();
        this.initForm();
        ScreenManager.setCenter((JDialog)((Object)this));
        this.initTable();
        this.setCustid(Reg.getInstance().getValueString("CUST_DEFAULT"));
        this.dsv.addNavigationListener((NavigationListener)this);
        this.setBackground(ComponentResources.DIALOG_BACKGROUND);
        AbstractAction actF5 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DlgSearchItemPIDRental.this.doLoad();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(116, 0), "F5");
        this.getRootPane().getActionMap().put("F5", actF5);
    }

    public static synchronized DlgSearchItemPIDRental getInstance() {
        if (singleton == null) {
            singleton = new DlgSearchItemPIDRental();
            InstanceMgr.getInstance().addObserver((InstanceObserver)singleton);
        }
        return singleton;
    }

    public CurrencyGetter getCurrencyGetter() {
        return this.currencyGetter;
    }

    public void setCurrencyGetter(CurrencyGetter currencyGetter) {
        this.currencyGetter = currencyGetter;
    }

    private void initForm() {
        this.jBdbTable1.setEnabledAppendRow(false);
    }

    public void Reset() {
        singleton = null;
        this.fromTrans = null;
    }

    public void setWhID(String whid) {
        this.whid = whid;
    }

    public void navigated(NavigationEvent navigationEvent) {
    }

    public void refresh() {
        int limitrow = -1;
        this.sql = new StringBuffer(this.query);
        if (this.filter.length() > 0) {
            this.filter.delete(0, this.filter.length());
        }
        if (this.stringPID != null && this.stringPID.length() > 0) {
            JBSQL.ANDFilter((StringBuffer)this.filter, (String)("UPPER(s.pid) LIKE UPPER('%" + this.stringPID + "%') "));
        }
        if (this.pikItem1.getKeyValue() != null) {
            JBSQL.ANDFilterPicker((StringBuffer)this.filter, (String)"i.itemid", (JBPicker)this.pikItem1);
        }
        JBSQL.ANDFilterCombo((StringBuffer)this.filter, (String)"s.whid", (JBComboBox)this.jCboWh1);
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)"i.active=true");
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)"i.usepid=true");
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)"s.pid<>''");
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)"s.qty>0");
        JBSQL.setWHERE((StringBuffer)this.sql, (StringBuffer)this.filter);
        JBSQL.setORDERBY((StringBuffer)this.sql, (String)"whname,itemdesc,pid");
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), this.sql.toString()));
        this.qds.open();
        this.qds.getColumn("whid").setVisible(0);
        this.qds.getColumn("avgcost").setVisible(0);
        this.qds.getColumn("whname").setCaption(this.l.getMessageBL(Stock.class, "col.whid"));
        this.qds.getColumn("whname").setWidth(10);
        this.qds.getColumn("whname").setEditable(false);
        this.qds.getColumn("itemid").setCaption(this.l.getMessageBL(Item.class, "col.itemid"));
        this.qds.getColumn("itemid").setWidth(10);
        this.qds.getColumn("itemid").setEditable(false);
        this.qds.getColumn("itemdesc").setCaption(this.l.getMessageBL(Item.class, "col.itemdesc"));
        this.qds.getColumn("itemdesc").setWidth(14);
        this.qds.getColumn("itemdesc").setEditable(false);
        this.qds.getColumn("pid").setCaption(this.l.getMessageBL(Stock.class, "col.pid"));
        this.qds.getColumn("pid").setWidth(10);
        this.qds.getColumn("pid").setEditable(false);
        this.qds.getColumn("qtyunit").setCaption("Stock");
        this.qds.getColumn("qtyunit").setWidth(10);
        this.qds.getColumn("qtyunit").setEditable(false);
        this.qds.getColumn("qtyunit").setVisible(this.STOCK_ENABLED ? 1 : 0);
        this.qds.setEditable(false);
        if (this.dsv.isOpen()) {
            this.dsv.close();
        }
        this.dsv.setStorageDataSet(this.qds.getStorageDataSet());
        this.dsv.open();
    }

    protected void f1Action() {
        this.stringPID = JOptionPane.showInputDialog((Component)((Object)this), (Object)"Masukkan PID");
        if (this.stringPID != null && this.stringPID.length() > 0) {
            this.doLoad();
            this.stringPID = null;
        }
    }

    private boolean isDuplicate(String id) {
        DataRow dr = new DataRow(this.pid.getDataSet(), "pid");
        dr.setString("pid", id.trim());
        DataRow result = new DataRow(this.pid.getDataSet());
        return this.pid.getDataSet().lookup((ReadRow)dr, result, 32);
    }

    public void setBTrans(BTrans trans) {
        this.trans = trans;
        this.usePrice = true;
    }

    private void ItemSetPerformed(String itemid) {
        this.price = BigDecimal.ZERO;
        this.discexp = null;
    }

    public void setDetails(DataSet ds) {
        this.setDetails(ds, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(DataSet ds, boolean isFromSttr, String WhID1) {
        this.bypass = true;
        try {
            this.lastds = ds;
            if (ds != null) {
                if (ds.getString("itemid") != null && ItemList.getInstance().isItemValid(ds.getString("itemid"))) {
                    this.pikItem1.setKeyValue(ds.getString("itemid"));
                    if (!isFromSttr && ds.getString("whid") != null && ds.getString("whid").length() > 0) {
                        this.jCboWh1.setKeyValue(ds.getString("whid"));
                        this.jCboWh1.setVisible(true);
                        this.jLabel3.setVisible(true);
                    }
                    if (this.isUsePrice() && ds.getBigDecimal("listprice") != null) {
                        this.price = ds.getBigDecimal("listprice");
                        if (ds.getString("discexp") != null) {
                            this.discexp = ds.getString("discexp");
                        }
                    }
                }
                if (isFromSttr) {
                    this.jCboWh1.setKeyValue(WhID1);
                    this.jCboWh1.setVisible(false);
                    this.jLabel3.setVisible(false);
                }
            }
        }
        finally {
            this.bypass = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDetailPID(String pid) throws Exception {
        int bookmark = this.trans.getDataSetDetail().getRow();
        int detailCount = this.trans.getDataSetDetail().getRowCount();
        this.trans.setBypass(true);
        this.trans.enableDataSetEvents(false);
        try {
            for (int i = 0; i < detailCount; ++i) {
                this.trans.getDataSetDetail().goToRow(i);
                if (!this.trans.getDataSetDetail().getString("pid").equals(pid)) continue;
                throw new Exception(String.format(this.getResourcesUI("ex.detailpid"), pid));
            }
        }
        finally {
            this.trans.enableDataSetEvents(true);
            this.trans.getDataSetDetail().goToRow(bookmark);
            this.trans.setBypass(false);
        }
    }

    private void AddItem() throws Exception {
        String pidku = BHelp.QuoteSingle((String)this.pidno.getText().toString());
        String itemidku = BHelp.QuoteSingle((String)this.pikItem1.getKeyValue());
        if (this.isDuplicate(this.dsv.getString("pid"))) {
            throw new Exception(this.getResourcesUI("ex.piddouble"));
        }
        if (this.trans != null) {
            this.checkDetailPID(this.dsv.getString("pid"));
        }
        if (!this.isDuplicate(this.dsv.getString("pid"))) {
            this.pid.getDataSet().emptyAllRows();
            this.pid.New();
            this.pid.getDataSet().setString("itemid", this.dsv.getString("itemid"));
            this.pid.getDataSet().setBigDecimal("qty", BigDecimal.ONE);
            this.pid.getDataSet().setString("whid", this.dsv.getString("whid"));
            this.pid.getDataSet().setString("unit", ItemList.getInstance().getUnit1(this.dsv.getString("itemid")));
            this.pid.getDataSet().setString("pid", this.dsv.getString("pid").trim());
            this.pid.getDataSet().setBigDecimal("avgcost", this.dsv.getBigDecimal("avgcost"));
            if (this.isUsePrice()) {
                if (this.price.compareTo(BigDecimal.ZERO) != 0) {
                    this.pid.getDataSet().setBigDecimal("listprice", this.price);
                    if (this.discexp != null) {
                        this.pid.getDataSet().setString("discexp", this.discexp);
                    }
                } else {
                    Price prc = this.iPriceList.getPrice_BP(this.trans, this.trans.getDataSetMaster().getString("crcid"), this.dsv.getString("itemid"), BigDecimal.ONE, ItemList.getInstance().getUnit1(this.dsv.getString("itemid")), this.trans.getDataSetMaster().getString("custid"), null);
                    if (prc != null) {
                        this.price = prc.getListPrice();
                        this.discexp = prc.getDiscExp();
                        this.pid.getDataSet().setBigDecimal("listprice", this.price);
                        this.pid.getDataSet().setString("discexp", this.discexp);
                    }
                }
            }
        }
        this.pidno.setText(null);
        this.pidno.requestFocus();
    }

    private void initTable() {
        DataSet ds = this.pid.getDataSet();
        for (int i = 0; i < this.pid.getDataSet().getColumnCount(); ++i) {
            ds.getColumn(i).setVisible(0);
        }
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            this.whid = null;
            this.setUseDefaWHID(true);
            this.setCurrencyGetter(null);
        } else if (visible && this.getWhid() == null && this.isUseDefaWHID()) {
            this.whid = ConfMgr.getConfig().getValByTag("WhID");
        }
        super.setVisible(visible);
    }

    private String getCrcId() {
        if (null != this.currencyGetter) {
            return this.currencyGetter.getCrcId();
        }
        return Cmp.getInstance().getCrcID();
    }

    public void doLoad() {
        this.refresh();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jBdbTable1 = new JBdbTable();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.pidno = new JTextBCode();
        this.jLabel2 = new JLabel();
        this.pikItem1 = new PikItem();
        this.jLabel3 = new JLabel();
        this.jCboWh1 = new JCboWh();
        this.jPanel4 = new JPanel();
        this.jPanel3 = new JPanel();
        this.btnCancel1 = new BtnCancel();
        this.btnOK1 = new BtnOK();
        this.jBToolbarDialog1 = new JBToolbarDialog();
        this.jBStatusbarDialog1 = new JBStatusbarDialog();
        this.setDefaultCloseOperation(2);
        this.jPanel2.setBackground(new Color(204, 204, 204));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jBdbTable1.setDataSet((DataSet)this.dsv);
        this.jBdbTable1.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DlgSearchItemPIDRental.this.jBdbTable1MouseClicked(evt);
            }
        });
        this.jBdbTable1.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                DlgSearchItemPIDRental.this.jBdbTable1KeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.jBdbTable1);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(238, 238, 238)), "Filter", 0, 0, new Font("Dialog", 1, 11)));
        this.jPanel1.setOpaque(false);
        this.jLabel1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel1.setText("PID :");
        this.pidno.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.pidno.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgSearchItemPIDRental.this.pidnoActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel2.setText("Item :");
        this.pikItem1.setBackground(new Color(204, 204, 204));
        this.pikItem1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.pikItem1.setOpaque(false);
        this.pikItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgSearchItemPIDRental.this.pikItem1ActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel3.setText("Gudang :");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.pikItem1, -1, 428, Short.MAX_VALUE).addGap(138, 138, 138)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jCboWh1, -2, 177, -2).addComponent((Component)this.pidno, -2, 204, -2)).addContainerGap(-1, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.pikItem1, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addGap(0, 5, Short.MAX_VALUE)).addComponent((Component)this.jCboWh1, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent((Component)this.pidno, -2, -1, -2)).addContainerGap()));
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new FlowLayout(2, 5, 0));
        this.btnCancel1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgSearchItemPIDRental.this.btnCancel1ActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.btnCancel1);
        this.btnOK1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgSearchItemPIDRental.this.btnOK1ActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.btnOK1);
        this.jPanel4.add((Component)this.jPanel3, "East");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 652, Short.MAX_VALUE).addComponent(this.jPanel4, -1, 652, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 159, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addGap(14, 14, 14)));
        this.jBToolbarDialog1.setEnableNew(false);
        this.jBToolbarDialog1.addJBToolbarListener(new JBToolbarListener(){

            public void toolbarCancelPerformed(JBToolbarEvent evt) {
            }

            public void toolbarDeletePerformed(JBToolbarEvent evt) {
            }

            public void toolbarPrintPerformed(JBToolbarEvent evt) {
            }

            public void toolbarRefreshPerformed(JBToolbarEvent evt) {
                DlgSearchItemPIDRental.this.jBToolbarDialog1ToolbarRefreshPerformed(evt);
            }

            public void toolbarNewPerformed(JBToolbarEvent evt) {
            }

            public void toolbarOpenPerformed(JBToolbarEvent evt) {
            }

            public void toolbarEditPerformed(JBToolbarEvent evt) {
            }

            public void toolbarSavePerformed(JBToolbarEvent evt) {
            }

            public void toolbarVoidPerformed(JBToolbarEvent evt) {
            }
        });
        this.jBStatusbarDialog1.setCaptF2("");
        this.jBStatusbarDialog1.setShowF2(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent((Component)this.jBToolbarDialog1, -1, 702, Short.MAX_VALUE).addComponent((Component)this.jBStatusbarDialog1, -1, 702, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent((Component)this.jBToolbarDialog1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jBStatusbarDialog1, -2, -1, -2)));
        this.pack();
    }

    private void pidnoActionPerformed(ActionEvent evt) {
        this.doLoad();
    }

    private void jBToolbarDialog1ToolbarRefreshPerformed(JBToolbarEvent evt) {
        this.doLoad();
    }

    private void btnCancel1ActionPerformed(ActionEvent evt) {
        this.Cancel();
    }

    private void btnOK1ActionPerformed(ActionEvent evt) {
        try {
            this.AddItem();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.setSelectedObject(this.pid);
        this.OK();
    }

    private void jBdbTable1KeyPressed(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            try {
                this.AddItem();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setSelectedObject(this.pid);
            this.OK();
        }
    }

    private void jBdbTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            try {
                this.AddItem();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setSelectedObject(this.pid);
            this.OK();
        }
    }

    private void pikItem1ActionPerformed(ActionEvent evt) {
        if (this.bypass) {
            return;
        }
        if (this.pikItem1.getKeyValue() != null) {
            String localItemId = this.pikItem1.getKeyValue();
            if (ItemList.getInstance().isItemValid(localItemId)) {
                this.ItemSetPerformed(localItemId);
            }
        }
    }

    public void doUpdate() {
        singleton = null;
    }

    public String getCustid() {
        return this.custid;
    }

    public void setCustid(String custid) {
        this.custid = custid;
    }

    public String getWhid() {
        return this.whid;
    }

    public boolean isUseDefaWHID() {
        return this.useDefaWHID;
    }

    public void setUseDefaWHID(boolean useDefaWHID) {
        this.useDefaWHID = useDefaWHID;
    }

    private void initLang() {
        this.setTitle(this.getResourcesUI("title"));
        this.jLabel1.setText(this.getResourcesUI("jLabel1.text"));
        ((TitledBorder)this.jPanel1.getBorder()).setTitle(this.getResourcesUI("jPanel1.border.Title"));
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(DlgSearchItemPID.class, key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(DlgSearchItemPID.class, key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(DlgSearchItemPID.class, key);
    }

    public String getItemid() {
        return this.itemid;
    }

    public void setItemid(String itemid) {
        if (itemid != null && !itemid.equalsIgnoreCase("")) {
            this.itemid = itemid;
            this.pikItem1.setKeyValue(itemid);
            this.doLoad();
        }
    }

    public boolean isUsePrice() {
        return this.usePrice;
    }

    public void setUsePrice(boolean usePrice) {
        this.usePrice = usePrice;
    }
}

