/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.pluginpersewaan.ui.swing;

import com.bits.bee.pluginpersewaan.ui.FrmBooking;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.myswing.CalendarListModel;
import com.bits.bee.ui.myswing.CalendarListener;
import com.bits.bee.ui.myswing.JBCalendar;
import com.bits.bee.ui.myswing.JBCalendarPnlButton;
import com.bits.bee.ui.myswing.PnlButtonListener;
import com.bits.lib.BHelp;
import com.bits.lib.DateDif;
import com.bits.lib.dbswing.JBdbTable;
import com.bits.lib.dx.BDM;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.bits.lib.swing.JDropDownButton;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import com.toedter.calendar.JMonthChooser;
import com.toedter.calendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBCalendarBooking
extends JPanel
implements CalendarListener,
PnlButtonListener,
ResourceGetter {
    private LocaleInstance l = LocaleInstance.getInstance();
    private static Logger logger = LoggerFactory.getLogger(JBCalendarBooking.class);
    private int CALENDAR_HEIGHT;
    private int CALENDAR_WIDTH;
    private Calendar calendar;
    private Calendar tempCalendar;
    private Calendar genCalendar = new GregorianCalendar();
    private Calendar helpCalendar;
    private java.util.Date startDate;
    private java.util.Date endDate;
    private int month;
    private int year;
    private int date;
    private int minDays;
    private int maxDate;
    private int dateNow;
    private int monthNow;
    private int yearNow;
    private int now;
    private JBCalendarPnlButton[][] btnArray;
    private JLabel[] daysLabel;
    private static String[] days = new String[]{"Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"};
    private JPanel panelDays;
    private JPanel panelDates;
    private JButton btn = new JButton();
    private JBCalendarPnlButton calBtn = new JBCalendarPnlButton();
    private boolean doPropertyChange = true;
    private JLabel label;
    private static final SimpleDateFormat calendarFormat = new SimpleDateFormat("EEEE, dd MMMM yyyy");
    private QueryDataSet qds = new QueryDataSet();
    private QueryDataSet qdsStock = new QueryDataSet();
    private HashMap<Integer, HashMap<String, StringBuffer>> eventMap = new HashMap();
    private HashMap<Integer, ArrayList<String>> todoMap = new HashMap();
    private Integer key;
    String[] bufPiutang;
    String[] bufHutang;
    String[] bufGiroIn;
    String[] bufGiroOut;
    String[] bufTodoNote;
    CalendarListModel calendarList = new CalendarListModel();
    private DataSetView dsv = new DataSetView();
    private DataSetView dsvStock = new DataSetView();
    private JButton btnLeft;
    private JButton btnRight;
    private JButton btnToday;
    private JBdbTable jBdbTable1;
    private JBdbTable jBdbTable2;
    private JBdbTable jBdbTable3;
    private JDropDownButton jDropDownButton1;
    private JMonthChooser jMonthChooser1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JYearChooser jYearChooser1;
    private JPanel pnlCalendar;
    private JPanel pnlControl;

    public JBCalendarBooking() {
        this.initComponents();
        this.jMonthChooser1.setFont(new Font("Dialog", 1, 9));
        this.jYearChooser1.setFont(new Font("Dialog", 1, 9));
        this.startDate = new java.util.Date();
        this.endDate = new java.util.Date();
        this.initForm();
        this.setNow();
    }

    private void showTodoPanel(boolean show) {
    }

    private void initLang() {
        this.btnToday.setText(this.getResourcesUI("btnToday.text"));
    }

    private void loadEvent() throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT b.bookingno,b.bookingdate,bp.bpname,b.startrentdate,b.endrentdate FROM booking b JOIN bp ON (b.custid = bp.bpid) WHERE b.endrentdate>=" + BHelp.QuoteDate((java.util.Date)this.startDate) + "AND" + " b.startrentdate<=" + BHelp.QuoteDate((java.util.Date)this.endDate));
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setAllRowIds(true);
        this.qds.setMetaDataUpdate(0);
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qds.open();
    }

    private void setYear(int year) {
        this.calendar.set(year, this.month, this.date);
        this.now = 0;
        this.tempCalendar.set(year, this.month, 1);
        this.setCalendar();
        if (this.isDateNow()) {
            this.label.setText(this.getResourcesUI("label.text.todaydate") + calendarFormat.format(this.tempCalendar.getTime()));
        } else {
            this.label.setText(this.getResourcesUI("label.text.date") + calendarFormat.format(this.tempCalendar.getTime()));
        }
    }

    private void setMonth(int month) {
        this.calendar.setTime(DateDif.getMonthBefore((java.util.Date)this.calendar.getTime(), (int)(month - this.month)));
        this.now = 0;
        this.tempCalendar.set(this.year, month, 1);
        this.setCalendar();
        if (this.isDateNow()) {
            this.label.setText(this.getResourcesUI("label.text.todaydate") + calendarFormat.format(this.tempCalendar.getTime()));
        } else {
            this.label.setText(this.getResourcesUI("label.text.date") + calendarFormat.format(this.tempCalendar.getTime()));
        }
    }

    private void setNow() {
        GregorianCalendar cal = new GregorianCalendar();
        this.now = cal.get(5);
        this.dateNow = cal.get(5);
        this.monthNow = cal.get(2);
        this.yearNow = cal.get(1);
        this.setCalendar(cal);
    }

    private boolean isNow() {
        return this.month == this.monthNow && this.year == this.yearNow;
    }

    private boolean isDateNow() {
        return this.isDateNow(this.date, this.month, this.year);
    }

    private boolean isDateNow(int date, int month, int year) {
        return date == this.dateNow && month == this.monthNow && year == this.yearNow;
    }

    private void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.setCalendar();
    }

    private void setCalendar() {
        this.year = this.calendar.get(1);
        this.month = this.calendar.get(2);
        this.date = this.calendar.get(5);
        this.minDays = DateDif.getDay((java.util.Date)DateDif.getFirstDate((java.util.Date)this.calendar.getTime()));
        this.maxDate = DateDif.getDayofMonth((java.util.Date)this.calendar.getTime()) + this.minDays;
        if (this.isNow()) {
            this.now = this.dateNow;
        }
        this.helpCalendar.set(this.year, this.month, 1);
        this.startDate = this.helpCalendar.getTime();
        this.helpCalendar.set(this.year, this.month, DateDif.getDayofMonth((java.util.Date)this.calendar.getTime()));
        this.endDate = this.helpCalendar.getTime();
        this.drawCalendar();
    }

    private void initForm() {
        int i;
        this.tempCalendar = new GregorianCalendar();
        this.helpCalendar = new GregorianCalendar();
        this.label = new JLabel();
        this.label.setText("Ini Label");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add(this.label);
        this.daysLabel = new JLabel[7];
        this.btnArray = new JBCalendarPnlButton[6][7];
        for (i = 0; i < this.daysLabel.length; ++i) {
            JLabel localLabel = new JLabel(days[i]);
            localLabel.setBorder(BorderFactory.createEtchedBorder());
            localLabel.setBackground(new Color(153, 153, 255));
            localLabel.setHorizontalAlignment(0);
            this.daysLabel[i] = localLabel;
        }
        for (i = 0; i < this.btnArray.length; ++i) {
            for (int j = 0; j < 7; ++j) {
                JBCalendarPnlButton button = new JBCalendarPnlButton();
                if (j == 0) {
                    button.setDateForeground(Color.RED);
                } else {
                    button.setDateForeground(Color.BLUE);
                }
                button.setPnlButtonListener((PnlButtonListener)this);
                button.setCalendarListener((CalendarListener)this);
                this.btnArray[i][j] = button;
            }
        }
        this.panelDays = new JPanel();
        this.panelDays.setLayout(new GridLayout(0, 7, 1, 1));
        this.panelDates = new JPanel();
        this.panelDates.setLayout(new GridLayout(0, 7, 1, 1));
        this.pnlCalendar.setLayout(new BorderLayout());
        this.pnlCalendar.add((Component)this.panelDays, "North");
        this.pnlCalendar.add((Component)this.panelDates, "Center");
        for (i = 0; i < this.daysLabel.length; ++i) {
            this.daysLabel[i].setFont(new Font("Dialog", 1, 10));
            if (i == 0) {
                this.daysLabel[i].setForeground(Color.RED);
            } else {
                this.daysLabel[i].setForeground(Color.BLUE);
            }
            this.panelDays.add(this.daysLabel[i]);
        }
        for (i = 0; i < this.btnArray.length; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.panelDates.add((Component)this.btnArray[i][j]);
            }
        }
    }

    private void drawCalendar() {
        try {
            this.loadEvent();
            this.eventMap.clear();
            for (int i = 0; i < this.qds.getRowCount(); ++i) {
                this.qds.goToRow(i);
                this.parseEvent(this.qds.getString(0));
            }
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)this.getResourcesUI("ex.load"), (Exception)ex, (Component)this, (Logger)logger);
        }
        int counter = 0;
        int dayCounter = 0;
        for (int i = 0; i < this.btnArray.length; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (++counter > this.minDays && counter <= this.maxDate) {
                    this.btnArray[i][j].getHTMLGenerator().resetData();
                    Integer localKey = ++dayCounter;
                    if (j == 0) {
                        this.btnArray[i][j].setDateForeground(Color.RED);
                    } else {
                        this.btnArray[i][j].setDateForeground(Color.BLUE);
                    }
                    this.btnArray[i][j].setText("" + dayCounter);
                    this.genCalendar.set(this.year, this.month, dayCounter);
                    this.btnArray[i][j].setDate(dayCounter);
                    this.btnArray[i][j].setSqlDate(new Date(this.genCalendar.getTime().getTime()));
                    this.btnArray[i][j].setEnabledPanel(true);
                    this.btnArray[i][j].setBackground(this.calBtn.getBackground());
                    this.btnArray[i][j].setDateBackground(this.calBtn.getBackground());
                    this.btnArray[i][j].setEventBackground(this.calBtn.getBackground());
                    this.btnArray[i][j].setIsNow(false);
                    if (dayCounter != this.now) continue;
                    this.btnArray[i][j].doClick();
                    this.btnArray[i][j].setIsNow(true);
                    this.btnArray[i][j].setBackground(JBCalendarPnlButton.FOCUS_COLOR);
                    this.btnArray[i][j].setDateBackground(JBCalendarPnlButton.FOCUS_COLOR);
                    this.btnArray[i][j].setEventBackground(JBCalendarPnlButton.FOCUS_COLOR);
                    continue;
                }
                this.btnArray[i][j].setText("");
                this.btnArray[i][j].setDate(0);
                this.btnArray[i][j].setEnabledPanel(false);
                this.btnArray[i][j].setIsNow(false);
                this.btnArray[i][j].setBackground(this.calBtn.getBackground());
                this.btnArray[i][j].setDateBackground(this.calBtn.getBackground());
                this.btnArray[i][j].setEventBackground(this.calBtn.getBackground());
            }
        }
    }

    private void parseEvent(String event) {
    }

    private void updateListModel(JBCalendarPnlButton btn) {
        int i;
        this.bufPiutang = btn.getHTMLGenerator().getDivPiutang().split(".\n");
        this.bufHutang = btn.getHTMLGenerator().getDivHutang().split(".\n");
        this.bufGiroIn = btn.getHTMLGenerator().getDivGiroMasuk().split(".\n");
        this.bufGiroOut = btn.getHTMLGenerator().getDivGiroKeluar().split(".\n");
        this.bufTodoNote = btn.getHTMLGenerator().getDivTodoNote().split(".\n");
        boolean first = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (i = 0; i < this.bufPiutang.length; ++i) {
            if (this.bufPiutang[i] == null || this.bufPiutang[i].length() <= 0) continue;
            if (first) {
                arrayList.add(this.getResourcesUI("vector.piutang"));
                first = false;
            }
            arrayList.add("  " + this.bufPiutang[i]);
        }
        first = true;
        for (i = 0; i < this.bufHutang.length; ++i) {
            if (this.bufHutang[i] == null || this.bufHutang[i].length() <= 0) continue;
            if (first) {
                arrayList.add(this.getResourcesUI("vector.hutang"));
                first = false;
            }
            arrayList.add("  " + this.bufHutang[i]);
        }
        first = true;
        for (i = 0; i < this.bufGiroIn.length; ++i) {
            if (this.bufGiroIn[i] == null || this.bufGiroIn[i].length() <= 0) continue;
            if (first) {
                arrayList.add(this.getResourcesUI("vector.giroIn"));
                first = false;
            }
            arrayList.add("  " + this.bufGiroIn[i]);
        }
        first = true;
        for (i = 0; i < this.bufGiroOut.length; ++i) {
            if (this.bufGiroOut[i] == null || this.bufGiroOut[i].length() <= 0) continue;
            if (first) {
                arrayList.add(this.getResourcesUI("vector.giroOut"));
                first = false;
            }
            arrayList.add("  " + this.bufGiroOut[i]);
        }
        first = true;
        for (i = 0; i < this.bufTodoNote.length; ++i) {
            if (this.bufTodoNote[i] == null || this.bufTodoNote[i].length() <= 0) continue;
            if (first) {
                arrayList.add(this.getResourcesUI("vector.todo"));
                first = false;
            }
            arrayList.add("  " + this.bufTodoNote[i]);
        }
        this.calendarList.setModel(arrayList);
    }

    private void updateDataView() {
        for (int i = 0; i < this.btnArray.length; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (this.btnArray[i][j].getDate() <= 0) continue;
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jBdbTable2 = new JBdbTable();
        this.jDropDownButton1 = new JDropDownButton();
        this.pnlControl = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jMonthChooser1 = new JMonthChooser();
        this.jYearChooser1 = new JYearChooser();
        this.jPanel1 = new JPanel();
        this.btnRight = new JButton();
        this.btnLeft = new JButton();
        this.btnToday = new JButton();
        this.pnlCalendar = new JPanel();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jBdbTable1 = new JBdbTable();
        this.jPanel5 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jBdbTable3 = new JBdbTable();
        this.jScrollPane1.setViewportView((Component)this.jBdbTable2);
        this.jDropDownButton1.setText("jDropDownButton1");
        this.pnlControl.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanel3.setBackground(new Color(204, 204, 255));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jMonthChooser1.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JBCalendarBooking.this.jMonthChooser1PropertyChange(evt);
            }
        });
        this.jYearChooser1.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JBCalendarBooking.this.jYearChooser1PropertyChange(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent((Component)this.jMonthChooser1, -2, -1, -2).addGap(0, 0, 0).addComponent((Component)this.jYearChooser1, -2, -1, -2)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jMonthChooser1, -2, -1, -2).addComponent((Component)this.jYearChooser1, -2, -1, -2));
        this.btnRight.setFont(new Font("Dialog", 1, 9));
        this.btnRight.setText(">");
        this.btnRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JBCalendarBooking.this.btnRightActionPerformed(evt);
            }
        });
        this.btnLeft.setFont(new Font("Dialog", 1, 9));
        this.btnLeft.setText("<");
        this.btnLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JBCalendarBooking.this.btnLeftActionPerformed(evt);
            }
        });
        this.btnToday.setFont(new Font("Dialog", 1, 9));
        this.btnToday.setText("Today");
        this.btnToday.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JBCalendarBooking.this.btnTodayActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnLeft).addGap(0, 0, 0).addComponent(this.btnToday).addGap(0, 0, 0).addComponent(this.btnRight)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnLeft).addComponent(this.btnToday).addComponent(this.btnRight));
        GroupLayout pnlControlLayout = new GroupLayout(this.pnlControl);
        this.pnlControl.setLayout(pnlControlLayout);
        pnlControlLayout.setHorizontalGroup(pnlControlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlControlLayout.createSequentialGroup().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        pnlControlLayout.setVerticalGroup(pnlControlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(pnlControlLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)));
        this.pnlCalendar.setBorder(BorderFactory.createTitledBorder("Event Calendar"));
        GroupLayout pnlCalendarLayout = new GroupLayout(this.pnlCalendar);
        this.pnlCalendar.setLayout(pnlCalendarLayout);
        pnlCalendarLayout.setHorizontalGroup(pnlCalendarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 359, Short.MAX_VALUE));
        pnlCalendarLayout.setVerticalGroup(pnlCalendarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Daftar Booking"));
        this.jBdbTable1.setDataSet((DataSet)this.dsv);
        this.jBdbTable1.setEditable(false);
        this.jBdbTable1.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JBCalendarBooking.this.jBdbTable1MouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView((Component)this.jBdbTable1);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 647, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 198, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Stock"));
        this.jBdbTable3.setDataSet((DataSet)this.dsvStock);
        this.jBdbTable3.setEditable(false);
        this.jScrollPane3.setViewportView((Component)this.jBdbTable3);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jScrollPane3, -2, 210, -2).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlCalendar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE))).addComponent(this.pnlControl, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlControl, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel5, -2, -1, -2)).addComponent(this.pnlCalendar, -1, -1, Short.MAX_VALUE))));
    }

    private void jYearChooser1PropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("year") && this.doPropertyChange) {
            this.setYear(this.jYearChooser1.getYear());
        }
    }

    private void jMonthChooser1PropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("month") && this.doPropertyChange) {
            this.setMonth(this.jMonthChooser1.getMonth());
        }
    }

    private void btnLeftActionPerformed(ActionEvent evt) {
        this.setMonth(this.month - 1);
        this.doPropertyChange = false;
        this.jMonthChooser1.setMonth(this.month);
        if (this.year != this.jYearChooser1.getYear()) {
            this.jYearChooser1.setYear(this.year);
        }
        this.doPropertyChange = true;
        this.initTable();
    }

    private void btnTodayActionPerformed(ActionEvent evt) {
        this.setNow();
        this.doPropertyChange = false;
        if (this.month != this.jMonthChooser1.getMonth()) {
            this.jMonthChooser1.setMonth(this.month);
        }
        if (this.year != this.jYearChooser1.getYear()) {
            this.jYearChooser1.setYear(this.year);
        }
        this.doPropertyChange = true;
    }

    private void btnRightActionPerformed(ActionEvent evt) {
        this.setMonth(this.month + 1);
        this.doPropertyChange = false;
        this.jMonthChooser1.setMonth(this.month);
        if (this.year != this.jYearChooser1.getYear()) {
            this.jYearChooser1.setYear(this.year);
        }
        this.doPropertyChange = true;
        this.initTable();
    }

    private void jBdbTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            FrmBooking form = new FrmBooking();
            form.doEdit(this.dsv.getString("bookingno"));
            ScreenManager.getMainFrame().addInternalFrame((JInternalFrame)((Object)form));
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test Frame");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add(new JBCalendarBooking());
        frame.pack();
        frame.setVisible(true);
    }

    public void eventClicked(JBCalendarPnlButton btn) {
        this.updateListModel(btn);
    }

    public void doEvent(JBCalendarPnlButton btn) {
        this.tempCalendar.set(this.year, this.month, btn.getDate());
        if (this.isDateNow(btn.getDate(), this.month, this.year)) {
            this.label.setText("Date" + calendarFormat.format(this.tempCalendar.getTime()));
        } else {
            this.label.setText(this.getResourcesUI("Date") + calendarFormat.format(this.tempCalendar.getTime()));
        }
        this.refresh(this.tempCalendar.getTime());
        this.refreshStock(this.tempCalendar.getTime());
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(JBCalendar.class, key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(JBCalendar.class, key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(JBCalendar.class, key);
    }

    private void refresh(java.util.Date date) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT b.bookingno,b.bookingdate,bp.bpname,b.startrentdate,b.endrentdate FROM booking b JOIN bp ON (b.custid = bp.bpid) WHERE b.endrentdate>=" + BHelp.QuoteDate((java.util.Date)date) + "AND" + " b.startrentdate<=" + BHelp.QuoteDate((java.util.Date)date));
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setAllRowIds(true);
        this.qds.setMetaDataUpdate(0);
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qds.open();
        if (this.dsv.isOpen()) {
            this.dsv.close();
        }
        this.initTable();
        this.dsv.setStorageDataSet(this.qds.getStorageDataSet());
        this.dsv.open();
    }

    private void refreshStock(java.util.Date date) {
        StringBuilder sql = new StringBuilder();
        sql.append(String.format("select itemid,itemdesc,itgrpid,qty,qtyp,qtybook,qtyrent,qtyavail from fstockavail(%s,%s,%s,%s,%s,%s)", null, null, BHelp.QuoteDate((java.util.Date)date), BHelp.QuoteDate((java.util.Date)date), BHelp.QuoteDate((java.util.Date)date), BHelp.QuoteDate((java.util.Date)date)));
        if (this.qdsStock.isOpen()) {
            this.qdsStock.close();
        }
        this.qdsStock.setAllRowIds(true);
        this.qdsStock.setMetaDataUpdate(0);
        this.qdsStock.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qdsStock.open();
        if (this.dsvStock.isOpen()) {
            this.dsvStock.close();
        }
        this.initTableStock();
        this.dsvStock.setStorageDataSet(this.qdsStock.getStorageDataSet());
        this.dsvStock.open();
    }

    private void initTable() {
        this.qds.getColumn("bookingno").setCaption("No. Booking");
        this.qds.getColumn("bookingno").setWidth(8);
        this.qds.getColumn("bookingdate").setCaption("Tgl. Booking");
        this.qds.getColumn("bookingdate").setWidth(8);
        this.qds.getColumn("bpname").setCaption("Customer");
        this.qds.getColumn("bpname").setWidth(17);
        this.qds.getColumn("startrentdate").setCaption("Tgl Sewa");
        this.qds.getColumn("startrentdate").setWidth(8);
        this.qds.getColumn("endrentdate").setCaption("Tgl Kembali");
        this.qds.getColumn("endrentdate").setWidth(8);
    }

    private void initTableStock() {
        this.qdsStock.getColumn("itemid").setCaption("Item");
        this.qdsStock.getColumn("itemdesc").setCaption("Nama Item");
        this.qdsStock.getColumn("qty").setCaption("Qty");
        this.qdsStock.getColumn("qtyp").setCaption("Qty Fisik");
        this.qdsStock.getColumn("qtyrent").setCaption("Qty Rent");
        this.qdsStock.getColumn("qtybook").setCaption("Qty Booked");
        this.qdsStock.getColumn("qtyavail").setCaption("Qty Available");
        this.qdsStock.getColumn("itgrpid").setVisible(0);
        this.qdsStock.getColumn("itemid").setWidth(6);
        this.qdsStock.getColumn("itemdesc").setWidth(13);
        this.qdsStock.getColumn("qty").setWidth(6);
        this.qdsStock.getColumn("qtyp").setWidth(6);
        this.qdsStock.getColumn("qtyrent").setWidth(8);
        this.qdsStock.getColumn("qtybook").setWidth(8);
        this.qdsStock.getColumn("qtyavail").setWidth(8);
    }
}

