/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.pluginpersewaan.ui.swing;

import com.bits.bee.bl.Reg;
import com.bits.bee.pluginpersewaan.bl.ItemRentList;
import com.bits.bee.pluginpersewaan.ui.dlg.DlgItemRent;
import com.bits.bee.ui.intellihint.IntelliHintAccept;
import com.bits.bee.ui.intellihint.PickerIntelliHints;
import com.bits.bee.ui.listener.ItemPostSaveHandler;
import com.bits.bee.ui.listener.ItemPostSaveHandlerStack;
import com.bits.bee.ui.myswing.PikItem;
import com.bits.lib.dbswing.BeforeShowHandler;
import com.bits.lib.dbswing.JBDialog;
import com.bits.lib.dbswing.JBPicker;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.borland.dx.dataset.ReadRow;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PikItemRent
extends JBPicker
implements ResourceGetter,
BeforeShowHandler,
ItemPostSaveHandler,
IntelliHintAccept {
    private static Logger logger = LoggerFactory.getLogger(PikItem.class);
    private boolean isCached = Reg.getInstance().getValueBooleanDefaultTrue("CACHEDLIST");
    private PickerIntelliHints hints;
    private LocaleInstance l = LocaleInstance.getInstance();
    private DlgItemRent dialog;
    private String itgrpid;

    public PikItemRent() {
        this.setPreferredSize(new Dimension(180, 19));
        this.initLang();
        this.initListener();
    }

    private void initListener() {
        this.setBeforeShowHandler(this);
    }

    public String getItemName(String id) {
        return this.getDescription(id);
    }

    protected String getDescription(String id) {
        return ItemRentList.getInstance().getItemDesc(id);
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(((Object)((Object)this)).getClass(), key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(((Object)((Object)this)).getClass(), key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(((Object)((Object)this)).getClass(), key);
    }

    private void initLang() {
        this.setToolTipText(this.getResourcesUI("toolTipText"));
    }

    public JBDialog getDefaultDialog() {
        if (null == this.dialog) {
            this.dialog = DlgItemRent.getInstance();
        }
        return this.dialog;
    }

    public void setItGrpID(String itgrpid) {
        this.itgrpid = itgrpid;
    }

    public void beforeShow() {
        if (this.itgrpid != null && this.itgrpid.length() > 0) {
            this.dialog.setItGrpID(this.itgrpid);
        }
        ItemPostSaveHandlerStack.getInstance().add((ItemPostSaveHandler)this);
    }

    public void setItemValue(String itemId) {
        this.setKeyValue(itemId);
    }

    public boolean filter(ReadRow row) {
        String id = row.getString("itemid");
        return !"0".equals(id) && !"-1".equals(id);
    }

    public void accept(String value) {
        this.setKeyValue(value);
        this.transferFocus();
    }

    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        if (null == this.hints && this.isCached) {
            this.hints = new PickerIntelliHints(this.getTextComponent(), ItemRentList.getInstance().getDataSet(), "itemid", "itemdesc", null, (IntelliHintAccept)this);
        }
    }
}

