/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.poincore.process;

import com.bits.bee.poincore.base.BPoinBundle;
import com.bits.bee.poincore.base.BPoinObject;
import com.bits.bee.poincore.base.BPoinRule;
import com.bits.bee.poincore.base.BPoinSubject;
import com.bits.bee.poincore.bl.PoinTrans;
import com.borland.dx.dataset.DataSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import org.openide.util.Lookup;

public class ProcessBundle {
    private ArrayList<BPoinBundle> queue;
    private Collection<? extends BPoinBundle> lookupAll;
    private BPoinSubject poinSubject;
    private BPoinObject poinObject;
    private BPoinRule poinRule;
    private PoinTrans trans;
    public static ProcessBundle singleton;

    public ProcessBundle() {
        this.initAllBundle();
    }

    private void initAllBundle() {
        this.lookupAll = Lookup.getDefault().lookupAll(BPoinBundle.class);
        this.queue = new ArrayList();
        for (BPoinBundle bPoinBundle : this.lookupAll) {
            this.queue.add(bPoinBundle);
        }
    }

    public static synchronized ProcessBundle getInstance() {
        if (null == singleton) {
            singleton = new ProcessBundle();
        }
        return singleton;
    }

    public void setTrans(PoinTrans trans) {
        this.trans = trans;
    }

    public PoinTrans getPoinTrans() {
        return this.trans;
    }

    public void doEstimate(DataSet dsDetail, DataSet dsMaster) {
        if (!this.queue.isEmpty()) {
            if (dsDetail.getRowCount() == 0) {
                this.trans.emptyAllRows();
                return;
            }
            this.trans.emptyAllRows();
            this.trans.New();
            this.trans.getDataSetMaster().setDate("poindate", dsMaster.getDate("saledate"));
            this.trans.getDataSetMaster().setString("custid", dsMaster.getString("custid"));
            this.trans.getDataSetMaster().setString("reftype", "SALE");
            this.trans.getDataSetMaster().setString("refno", dsMaster.getString("saleno"));
            System.out.println("queue " + this.queue.size());
            for (int i = 0; i < this.queue.size(); ++i) {
                BPoinBundle poinBundle = this.queue.get(i);
                this.poinSubject = poinBundle.getPoinSubject();
                this.poinObject = poinBundle.getPoinObject();
                this.poinRule = poinBundle.getPoinRule();
                this.poinSubject.createList(dsMaster.getString("custid"));
                DataSet rule = this.poinRule.getList(this.poinSubject, dsDetail, dsMaster);
                if (rule == null) continue;
                int ruleCount = rule.getRowCount();
                System.out.println("rule " + ruleCount);
                for (int indexOfRule = 0; indexOfRule < ruleCount; ++indexOfRule) {
                    rule.goToRow(indexOfRule);
                    DataSet object = this.poinObject.getList(this.poinSubject, this.poinRule, dsDetail, dsMaster);
                    if (object == null) continue;
                    int objectCount = object.getRowCount();
                    System.out.println("Object Count " + objectCount);
                    for (int indexOfObject = 0; indexOfObject < objectCount; ++indexOfObject) {
                        object.goToRow(indexOfObject);
                        boolean isGenerated = this.poinRule.calcValue(this.trans, this.poinObject);
                    }
                }
            }
            int count = this.trans.getDataSetDetail().getRowCount();
            BigDecimal qtyTotal = BigDecimal.ZERO;
            if (count > 0) {
                for (int x = 0; x < count; ++x) {
                    this.trans.getDataSetDetail().goToRow(x);
                    qtyTotal = qtyTotal.add(this.trans.getDataSetDetail().getBigDecimal("qtypoin"));
                }
                this.trans.getDataSetMaster().setBigDecimal("totalpoin", qtyTotal);
            }
        }
    }

    public void doProcess(String subjectID, String saleNo, Date saleDate) throws Exception {
        if (!this.queue.isEmpty()) {
            this.trans.emptyAllRows();
            this.trans.New();
            this.trans.getDataSetMaster().setDate("poindate", saleDate);
            this.trans.getDataSetMaster().setString("custid", subjectID);
            this.trans.getDataSetMaster().setString("reftype", "SALE");
            this.trans.getDataSetMaster().setString("refno", saleNo);
            System.out.println("queue " + this.queue.size());
            for (int i = 0; i < this.queue.size(); ++i) {
                BPoinBundle poinBundle = this.queue.get(i);
                this.poinSubject = poinBundle.getPoinSubject();
                this.poinObject = poinBundle.getPoinObject();
                this.poinRule = poinBundle.getPoinRule();
                this.poinSubject.createList(subjectID);
                DataSet ds = this.poinSubject.getList();
                DataSet rule = this.poinRule.getList(this.poinSubject, saleNo, subjectID);
                int ruleCount = rule.getRowCount();
                System.out.println("rule " + ruleCount);
                for (int indexOfRule = 0; indexOfRule < ruleCount; ++indexOfRule) {
                    rule.goToRow(indexOfRule);
                    DataSet object = this.poinObject.getList(this.poinSubject, this.poinRule, subjectID, saleNo);
                    int objectCount = object.getRowCount();
                    System.out.println("Object Count " + objectCount);
                    for (int indexOfObject = 0; indexOfObject < objectCount; ++indexOfObject) {
                        object.goToRow(indexOfObject);
                        boolean isGenerated = this.poinRule.calcValue(this.trans, this.poinObject);
                    }
                }
            }
            int count = this.trans.getDataSetDetail().getRowCount();
            BigDecimal qtyTotal = BigDecimal.ZERO;
            if (count > 0) {
                for (int x = 0; x < count; ++x) {
                    this.trans.getDataSetDetail().goToRow(x);
                    qtyTotal = qtyTotal.add(this.trans.getDataSetDetail().getBigDecimal("qtypoin"));
                }
                this.trans.getDataSetMaster().setBigDecimal("totalpoin", qtyTotal);
            }
        }
    }

    public int getDetailCount() {
        return this.trans.getDataSetDetail().getRowCount();
    }
}

