/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.poincore.ui;

import com.bits.bee.poincore.bl.BpRedimList;
import com.bits.bee.poincore.bl.PoinSale;
import com.bits.bee.poincore.bl.SaleTransPoin;
import com.bits.bee.ui.abstraction.AbstractAddPnlPos;
import com.bits.lib.dx.BTrans;
import com.borland.dbswing.JdbLabel;
import com.borland.dx.dataset.DataSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoinTotalPosPanel
extends AbstractAddPnlPos {
    private static final Logger logger = LoggerFactory.getLogger(PoinTotalPosPanel.class);
    private DataSet dspoinmaster;
    private final SaleAdptr saleAdapter = new SaleAdptr();
    private final SaleTransPoinAdptr stAdap = new SaleTransPoinAdptr();
    private DecimalFormat fDecimal = new DecimalFormat("#,##0.####");
    private JLabel jLabel47;
    private JLabel jLabel48;
    private JdbLabel lblCustPoin;
    private JdbLabel lblTotal;

    private void initComponents() {
        this.lblCustPoin = new JdbLabel();
        this.jLabel47 = new JLabel();
        this.jLabel48 = new JLabel();
        this.lblTotal = new JdbLabel();
        this.lblCustPoin.setHorizontalAlignment(4);
        this.lblCustPoin.setText("0");
        this.lblCustPoin.setFont(new Font("Dialog", 1, 14));
        this.jLabel47.setFont(new Font("Dialog", 1, 14));
        this.jLabel47.setForeground(new Color(1, 1, 1));
        this.jLabel47.setText("Poin saat ini ");
        this.jLabel48.setFont(new Font("Dialog", 1, 14));
        this.jLabel48.setForeground(new Color(1, 1, 1));
        this.jLabel48.setText("Estimasi poin didapat");
        this.lblTotal.setHorizontalAlignment(4);
        this.lblTotal.setText("0");
        this.lblTotal.setFont(new Font("Dialog", 1, 14));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel47, -2, 166, -2).addComponent(this.jLabel48)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.lblCustPoin, -1, 66, Short.MAX_VALUE).addComponent((Component)this.lblTotal, -1, -1, Short.MAX_VALUE)).addGap(6, 6, 6)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.lblCustPoin, -2, -1, -2).addComponent(this.jLabel47)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.lblTotal, -2, -1, -2).addComponent(this.jLabel48)).addGap(6, 6, 6)));
    }

    public PoinTotalPosPanel() {
        this.initComponents();
    }

    public void setSaleTrans(BTrans saleTrans) {
        super.setSaleTrans(saleTrans);
        this.init();
    }

    private void init() {
        this.getSaleTrans().getMaster().addPropertyChangeListener("custid", (PropertyChangeListener)this.saleAdapter);
        this.dspoinmaster = ((PoinSale)this.getSaleTrans().getDetail(6)).getPoinDataset();
        this.lblTotal.setDataSet(this.dspoinmaster);
        this.lblTotal.setColumnName("totalpoin");
        SaleTransPoin trans = (SaleTransPoin)this.getSaleTrans();
        trans.addPropertyChangeListener("load", this.stAdap);
        this.refresh();
    }

    private void refresh() {
        BpRedimList bpRedimList = new BpRedimList();
        if (this.getSaleTrans().getMaster().getString("custid").equals("CASH")) {
            this.lblCustPoin.setText("0");
        } else {
            this.lblCustPoin.setText(this.fDecimal.format(bpRedimList.getPoinRuleDescBeforeSale(this.getSaleTrans().getMaster().getString("custid"), this.getSaleTrans().getMaster().getString("saleno"))));
        }
    }

    class SaleTransPoinAdptr
    implements PropertyChangeListener {
        SaleTransPoinAdptr() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String propertyName = propertyChangeEvent.getPropertyName();
            if ("load".equalsIgnoreCase(propertyName)) {
                PoinTotalPosPanel.this.refresh();
            }
        }
    }

    class SaleAdptr
    implements PropertyChangeListener {
        SaleAdptr() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String propertyName = propertyChangeEvent.getPropertyName();
            if ("custid".equalsIgnoreCase(propertyName)) {
                PoinTotalPosPanel.this.refresh();
            }
        }
    }
}

