/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.poinstandart.rule;

import com.bits.bee.poincore.base.BPoinObject;
import com.bits.bee.poincore.base.BPoinRule;
import com.bits.bee.poincore.base.BPoinSubject;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BTrans;
import com.bits.lib.dx.JBSQL;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.math.BigDecimal;

public class PoinSretRuleTotalFaktur
implements BPoinRule {
    private QueryDataSet qds = new QueryDataSet();

    public String getRuleType() {
        return "Total Faktur";
    }

    public String getJoinTable() {
        return "poinrule";
    }

    public String getJoinColumn() {
        return null;
    }

    public DataSet getList(BPoinSubject poinSubject, String sretno, String string) {
        StringBuffer sql = new StringBuffer("SELECT poinruleno, poinruledesc, ismultiple, pointargetid, qtypoin, totalsale,crcid, startdate,enddate FROM poinrule");
        StringBuffer filter = new StringBuffer();
        JBSQL.ANDFilter((StringBuffer)filter, (String)"aktive = TRUE");
        JBSQL.ANDFilter((StringBuffer)filter, (String)("poinitypeid = " + BHelp.QuoteSingle((String)"ALL")));
        JBSQL.ANDFilter((StringBuffer)filter, (String)("poinconditionid = " + BHelp.QuoteSingle((String)"TOTAL")));
        if (poinSubject.getPoinRefType() != null && poinSubject.getPoinRefType().length() > 0) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"((pointargetid='GCUST'");
            JBSQL.ANDFilter((StringBuffer)filter, (String)String.format("bpgrpid = %s) OR pointargetid='ALL')", BHelp.QuoteSingle((String)poinSubject.getPoinRefType())));
        } else {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"pointargetid='ALL'");
        }
        JBSQL.setWHERE((StringBuffer)sql, (StringBuffer)filter);
        System.out.println("Poin rule query " + sql);
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qds.open();
        return this.qds;
    }

    public String getPoinRuleNo() {
        return this.qds.getString("poinruleno");
    }

    public String getCrc() {
        return this.qds.getString("crcid");
    }

    public boolean calcValue(BTrans poinTrans, BPoinObject poinObject) {
        boolean generated = true;
        DataSet dataSet = poinTrans.getDataSetDetail();
        short i = (short)(dataSet.getRowCount() + 1);
        DataRow dr = new DataRow(dataSet);
        dr.setString("poinno", poinTrans.getDataSetDetail().getString("poinno"));
        dr.setShort("poindno", i);
        dr.setString("poinmodul", poinObject.getPoinDesc());
        dr.setString("poincode", this.getPoinRuleNo());
        dr.setString("poinname", this.getRuleName());
        dr.setBigDecimal("qtypoin", poinObject.getQty());
        dr.setDate("poindate", poinObject.getDate());
        dataSet.addRow(dr);
        if (dataSet.getString("poinno").isEmpty() || dataSet.getString("poinno").length() <= 0) {
            generated = false;
        }
        return generated;
    }

    public String getRuleName() {
        return this.qds.getString("poinruledesc");
    }

    public BigDecimal getQtyPoin() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getItemid() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isMultiple() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BigDecimal getQtySale() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DataSet getList(BPoinSubject poinSubject, DataSet dsDetail, DataSet dsMaster) {
        return null;
    }

    public BigDecimal getTotalSale() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

