/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.poinstandart.ui;

import com.bits.bee.poinstandart.bl.PoinRule;
import com.bits.bee.ui.DlgAuth;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.exception.LimitOverException;
import com.bits.bee.ui.myswing.BtnDownloadXLS;
import com.bits.bee.ui.myswing.HelpBrowseStarter;
import com.bits.bee.ui.myswing.JPanelChooser;
import com.bits.bee.xls.XLSReader;
import com.bits.bee.xls.XLSUtils;
import com.bits.lib.BHelp;
import com.bits.lib.BUtil;
import com.bits.lib.dbswing.JBdbComboBox;
import com.bits.lib.dx.provider.BTableProvider;
import com.bits.lib.exception.BITSException;
import com.bits.lib.i18n.LocaleInstance;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.openide.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrmPoinRuleImport
extends JInternalFrame
implements PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(FrmPoinRuleImport.class);
    private static final int OPTIONAL = -1;
    private int PoinID;
    private int PoinName;
    private int StartPeriode;
    private int EndPeriode;
    private int QtyPoin;
    private int Multiply;
    private int MU;
    private int TotalFaktur;
    private int CustGroup;
    private int TargetPoin;
    private int Active;
    private final XLSReader reader;
    private final ArrayList<JBdbComboBox> alCombo = new ArrayList();
    private ArrayList<String> model;
    private String[] value;
    private static final String OBJID = "950003";
    private final LocaleInstance l = LocaleInstance.getInstance();
    private int error;
    private int success;
    private BtnDownloadXLS btnDownloadXLS1;
    private JButton btnProcess;
    private JButton btnRefreshForm;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel3;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel37;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanelChooser jPanelChooser1;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JBdbComboBox jcbActive;
    private JBdbComboBox jcbCustGroup;
    private JBdbComboBox jcbMu;
    private JBdbComboBox jcbMultiply;
    private JBdbComboBox jcbPeriodeEnd;
    private JBdbComboBox jcbPeriodeStart;
    private JBdbComboBox jcbPoinID;
    private JBdbComboBox jcbPoinName;
    private JBdbComboBox jcbQtyPoin;
    private JBdbComboBox jcbTargetPoin;
    private JBdbComboBox jcbTotalFaktur;
    private JTextArea txtLog;

    public FrmPoinRuleImport() {
        this.initComponents();
        this.initCombo();
        this.reader = new XLSReader();
        this.initListener();
        this.btnProcess.setEnabled(false);
        this.btnRefreshForm.setEnabled(false);
        BUtil.setEnabledPanel((JPanel)this.jPanel1, (boolean)false);
        this.initialize();
    }

    private void initialize() {
        if (!this.Auth()) {
            this.setVisible(false);
        }
    }

    private void initListener() {
        this.jPanelChooser1.addPropertyChangeListener("fileName", (PropertyChangeListener)this);
    }

    @Override
    public void setVisible(boolean visible) {
        DlgAuth dlgAuth = DlgAuth.getInstance();
        if (visible && dlgAuth.getSelectedID() == null) {
            super.setVisible(false);
        } else {
            super.setVisible(visible);
        }
    }

    private boolean Auth() {
        DlgAuth dlgAuth = DlgAuth.getInstance();
        dlgAuth.showAuth(OBJID, "ENB");
        return dlgAuth.getSelectedID() != null;
    }

    private void initCombo() {
        this.alCombo.add(this.jcbPoinID);
        this.alCombo.add(this.jcbPoinName);
        this.alCombo.add(this.jcbPeriodeStart);
        this.alCombo.add(this.jcbPeriodeEnd);
        this.alCombo.add(this.jcbQtyPoin);
        this.alCombo.add(this.jcbActive);
        this.alCombo.add(this.jcbMultiply);
        this.alCombo.add(this.jcbMu);
        this.alCombo.add(this.jcbTotalFaktur);
        this.alCombo.add(this.jcbTargetPoin);
        this.alCombo.add(this.jcbCustGroup);
    }

    private boolean cekCombo() {
        boolean status = true;
        this.PoinID = this.jcbPoinID.getSelectedIndex();
        this.PoinName = this.jcbPoinName.getSelectedIndex();
        this.StartPeriode = this.jcbPeriodeStart.getSelectedIndex();
        this.EndPeriode = this.jcbPeriodeEnd.getSelectedIndex();
        this.QtyPoin = this.jcbQtyPoin.getSelectedIndex();
        this.Active = this.jcbActive.getSelectedIndex();
        this.Multiply = this.jcbMultiply.getSelectedIndex();
        this.MU = this.jcbMu.getSelectedIndex();
        this.TotalFaktur = this.jcbTotalFaktur.getSelectedIndex();
        this.CustGroup = this.jcbCustGroup.getSelectedIndex();
        this.TargetPoin = this.jcbTargetPoin.getSelectedIndex();
        int[] data = new int[]{this.PoinID, this.PoinName, this.StartPeriode, this.EndPeriode, this.QtyPoin, this.Active, this.Multiply, this.MU, this.TotalFaktur, this.CustGroup, this.TargetPoin};
        block0: for (int i = 0; i < data.length; ++i) {
            int temp = data[i];
            for (int j = i + 1; j < data.length; ++j) {
                if (data[j] == -1 || data[j] != temp || temp == -1) continue;
                status = false;
                continue block0;
            }
        }
        return status;
    }

    private void validateFilter() throws Exception {
        if (!this.cekCombo()) {
            throw new Exception(this.l.getMessageUI(null, "ex.colsame"));
        }
        if (this.jcbPoinID.getSelectedIndex() < 0) {
            throw new Exception("Mohon pilih No Poin !");
        }
        if (this.jcbPoinName.getSelectedIndex() < 0) {
            throw new Exception("Mohon pilih Nama Poin !");
        }
        if (this.jcbQtyPoin.getSelectedIndex() < 0) {
            throw new Exception("Mohon pilih Qty Poin !");
        }
        if (this.jcbActive.getSelectedIndex() < 0) {
            throw new Exception("Mohon pilih Active !");
        }
        if (this.jcbMultiply.getSelectedIndex() < 0) {
            throw new Exception("Mohon pilih Kelipatan !");
        }
        if (this.jcbMu.getSelectedIndex() < 0) {
            throw new Exception("Mohon pilih Kode Mata Uang !");
        }
        if (this.jcbTotalFaktur.getSelectedIndex() < 0) {
            throw new Exception("Mohon pilih Total Faktur !");
        }
        if (this.jcbTargetPoin.getSelectedIndex() < 0) {
            throw new Exception("Mohon pilih Target Poin !");
        }
    }

    private void readFile() {
        int i;
        try {
            this.reader.readFile(this.jPanelChooser1.getFilePath());
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)this.l.getMessageUI(null, "ex.readfile"), (Exception)ex, (Component)this, (Logger)logger);
        }
        this.model = this.reader.getWBHeader();
        this.value = new String[this.model.size()];
        for (i = 0; i < this.model.size(); ++i) {
            this.value[i] = this.model.get(i);
        }
        for (i = 0; i < this.alCombo.size(); ++i) {
            this.alCombo.get(i).setModel(new DefaultComboBoxModel<String>(this.value));
            try {
                this.alCombo.get(i).setSelectedIndex(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public java.util.Date getDateBefore(int dayBefore) {
        GregorianCalendar cal = new GregorianCalendar();
        java.util.Date date = new java.util.Date(Date.valueOf("1900-01-01").getTime());
        cal.setTime(date);
        cal.add(5, dayBefore);
        return cal.getTime();
    }

    private Date ConvertToDate(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        java.util.Date initDate = sdf.parse(date);
        Date parsetgl = new Date(initDate.getTime());
        return parsetgl;
    }

    private void readData() throws LimitOverException {
        try {
            this.PoinID = this.jcbPoinID.getSelectedIndex();
            this.PoinName = this.jcbPoinName.getSelectedIndex();
            this.StartPeriode = this.jcbPeriodeStart.getSelectedIndex();
            this.EndPeriode = this.jcbPeriodeEnd.getSelectedIndex();
            this.QtyPoin = this.jcbQtyPoin.getSelectedIndex();
            this.Active = this.jcbActive.getSelectedIndex();
            this.Multiply = this.jcbMultiply.getSelectedIndex();
            this.MU = this.jcbMu.getSelectedIndex();
            this.TotalFaktur = this.jcbTotalFaktur.getSelectedIndex();
            this.CustGroup = this.jcbCustGroup.getSelectedIndex();
            this.TargetPoin = this.jcbTargetPoin.getSelectedIndex();
            ArrayList data = this.reader.getDataByIndex();
            for (int i = 1; i < data.size(); ++i) {
                try {
                    Date tgl;
                    Date date;
                    ArrayList temp = (ArrayList)data.get(i);
                    int size = temp.size();
                    Boolean aktive = null;
                    if (XLSUtils.trimmedOrNull((String)((String)temp.get(this.Active))) != null && XLSUtils.trimmedOrNull((String)((String)temp.get(this.Active))).length() > 0) {
                        aktive = Boolean.valueOf((String)temp.get(this.Active));
                    }
                    Boolean ismultiple = null;
                    if (XLSUtils.trimmedOrNull((String)((String)temp.get(this.Multiply))) != null && XLSUtils.trimmedOrNull((String)((String)temp.get(this.Multiply))).length() > 0) {
                        ismultiple = Boolean.valueOf((String)temp.get(this.Multiply));
                    }
                    String crcid = XLSUtils.trimmedOrNull((String)((String)temp.get(this.MU)));
                    String pointargetid = XLSUtils.trimmedOrNull((String)((String)temp.get(this.TargetPoin)));
                    String bpgrpid = XLSUtils.trimmedOrNull((String)((String)temp.get(this.CustGroup)));
                    String poinruleno = XLSUtils.trimmedOrNull((String)((String)temp.get(this.PoinID)));
                    String poinruledesc = XLSUtils.trimmedOrNull((String)((String)temp.get(this.PoinName)));
                    BigDecimal qtypoin = null;
                    if (XLSUtils.trimmedOrNull((String)((String)temp.get(this.QtyPoin))) != null && XLSUtils.trimmedOrNull((String)((String)temp.get(this.QtyPoin))).length() > 0) {
                        qtypoin = new BigDecimal((String)temp.get(this.QtyPoin));
                    }
                    BigDecimal totalsale = null;
                    if (XLSUtils.trimmedOrNull((String)((String)temp.get(this.TotalFaktur))) != null && XLSUtils.trimmedOrNull((String)((String)temp.get(this.TotalFaktur))).length() > 0) {
                        totalsale = new BigDecimal((String)temp.get(this.TotalFaktur));
                    }
                    if (poinruleno == null || poinruleno.length() <= 0) {
                        throw new Exception("Nomer poin tidak boleh kosong !");
                    }
                    if (poinruledesc == null || poinruledesc.length() <= 0) {
                        throw new Exception("Nama poin Pada No. Poin # " + poinruleno + " kosong !");
                    }
                    if (qtypoin == null) {
                        throw new Exception("Quantity poin Pada No. Poin # " + poinruleno + " kosong !");
                    }
                    if (qtypoin.compareTo(BigDecimal.ZERO) < 0) {
                        throw new Exception("Quantity poin Pada No. Poin # " + poinruleno + " kurang dari 0 !");
                    }
                    if (aktive == null) {
                        throw new Exception("Active Pada No. Poin # " + poinruleno + " kosong !");
                    }
                    if (ismultiple == null) {
                        throw new Exception("Kelipatan Pada No. Poin # " + poinruleno + " kosong !");
                    }
                    if (crcid == null || crcid.length() <= 0) {
                        throw new Exception("Kode Mata Uang Pada No. Poin # " + poinruleno + " kosong !");
                    }
                    if (totalsale == null) {
                        throw new Exception("Total Faktur Pada No. Poin # " + poinruleno + " kosong !");
                    }
                    if (qtypoin.compareTo(BigDecimal.ZERO) < 0) {
                        throw new Exception("Total Faktur Pada No. Poin # " + poinruleno + " kurang dari 0 !");
                    }
                    if (pointargetid == null || pointargetid.length() <= 0) {
                        throw new Exception("Target Poin Pada No. Poin # " + poinruleno + " kosong !");
                    }
                    if (pointargetid != null && pointargetid.equalsIgnoreCase("GCUST") && (bpgrpid == null || bpgrpid.length() <= 0)) {
                        throw new Exception("Kode Grup Customer Pada No. Poin # " + poinruleno + " kosong !");
                    }
                    PoinRule.getInstance().Load();
                    boolean exist = pointargetid != null && pointargetid.equalsIgnoreCase("GCUST") ? PoinRule.getInstance().GetExist(aktive, ismultiple, pointargetid, bpgrpid, totalsale) : PoinRule.getInstance().GetExist(aktive, ismultiple, pointargetid, null, totalsale);
                    if (exist) {
                        throw new Exception("Aturan poin #" + poinruleno + " sudah ada!");
                    }
                    PoinRule poinrule = (PoinRule)BTableProvider.createTable(PoinRule.class);
                    poinrule.New();
                    poinrule.getDataSet().setString("poinruleno", poinruleno);
                    poinrule.getDataSet().setString("poinruledesc", poinruledesc);
                    if (this.StartPeriode != -1 && size > this.StartPeriode && XLSUtils.isNotNullOrEmpty((String)((String)temp.get(this.StartPeriode)))) {
                        try {
                            new BigDecimal((String)temp.get(this.StartPeriode));
                            date = new Date(this.getDateBefore(XLSUtils.getIntValue((String)((String)temp.get(this.StartPeriode))) - 2).getTime());
                            poinrule.getDataSet().setDate("startdate", date);
                        }
                        catch (NumberFormatException ex) {
                            tgl = this.ConvertToDate((String)temp.get(this.StartPeriode));
                            poinrule.getDataSet().setDate("startdate", tgl);
                        }
                    } else {
                        poinrule.getDataSet().setDate("startdate", null);
                    }
                    if (this.EndPeriode != -1 && size > this.EndPeriode && XLSUtils.isNotNullOrEmpty((String)((String)temp.get(this.EndPeriode)))) {
                        try {
                            new BigDecimal((String)temp.get(this.EndPeriode));
                            date = new Date(this.getDateBefore(XLSUtils.getIntValue((String)((String)temp.get(this.EndPeriode))) - 2).getTime());
                            poinrule.getDataSet().setDate("enddate", date);
                        }
                        catch (NumberFormatException ex) {
                            tgl = this.ConvertToDate((String)temp.get(this.EndPeriode));
                            poinrule.getDataSet().setDate("enddate", tgl);
                        }
                    } else {
                        poinrule.getDataSet().setDate("enddate", null);
                    }
                    poinrule.getDataSet().setString("poinitypeid", "ALL");
                    poinrule.getDataSet().setString("itgrpid", null);
                    poinrule.getDataSet().setString("brandid", null);
                    poinrule.getDataSet().setString("itemid", null);
                    poinrule.getDataSet().setString("poinconditionid", "TOTAL");
                    poinrule.getDataSet().setBoolean("ismultiple", ismultiple.booleanValue());
                    poinrule.getDataSet().setBoolean("aktive", aktive.booleanValue());
                    poinrule.getDataSet().setString("pointargetid", pointargetid);
                    if (pointargetid != null && pointargetid.equalsIgnoreCase("ALL")) {
                        poinrule.getDataSet().setString("bpgrpid", null);
                    } else if (pointargetid != null && pointargetid.equalsIgnoreCase("GCUST")) {
                        poinrule.getDataSet().setString("bpgrpid", bpgrpid);
                    }
                    poinrule.getDataSet().setBigDecimal("qtypoin", qtypoin);
                    poinrule.getDataSet().setBigDecimal("totalsale", totalsale);
                    poinrule.getDataSet().setString("crcid", crcid);
                    try {
                        poinrule.saveChanges();
                        this.txtLog.append(String.format(this.l.getMessageUI(null, "ok.row"), i));
                        ++this.success;
                    }
                    catch (Exception ex) {
                        this.writeErrorMessage(i, this.errMassage(BHelp.getExceptionDetail((Exception)ex), ex, poinrule));
                    }
                    continue;
                }
                catch (Exception ex) {
                    this.writeErrorMessage(i, ex);
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    private Exception errMassage(String errMsg, Exception cause, PoinRule poinRule) {
        Object ex = errMsg.contains("pk_poinrule") ? new BITSException("0", "No Poin #" + poinRule.getDataSet().getString("poinruleno") + " Sudah ada !", (Throwable)cause) : (errMsg.contains("fk_poinrule_relations_pointitype") ? new BITSException("0", "Kode Tipe Poin #" + poinRule.getDataSet().getString("poinitypeid") + " Pada No. Poin #" + poinRule.getDataSet().getString("PoinRuleNo") + " Tidak Ditemukan Pada Master Tipe Poin !", (Throwable)cause) : (errMsg.contains("fk_poinrule_relations_itgrp") ? new BITSException("0", "Kode Item Grup #" + poinRule.getDataSet().getString("itgrpid") + " Pada No. Poin #" + poinRule.getDataSet().getString("PoinRuleNo") + " Tidak Ditemukan Pada Master Item Grup !", (Throwable)cause) : (errMsg.contains("fk_poinrule_relations_brand") ? new BITSException("0", "Kode Merek #" + poinRule.getDataSet().getString("brandid") + " Pada No. Poin #" + poinRule.getDataSet().getString("PoinRuleNo") + " Tidak Ditemukan Pada Master Merek !", (Throwable)cause) : (errMsg.contains("fk_poinrule_relations_crc") ? new BITSException("0", "Kode Mata Uang #" + poinRule.getDataSet().getString("itemid") + " Pada No. Poin #" + poinRule.getDataSet().getString("PoinRuleNo") + " Tidak Ditemukan Pada Master Mata Uang !", (Throwable)cause) : (errMsg.contains("fk_poinrule_relations_poincondition") ? new BITSException("0", "Kode Syarat Poin #" + poinRule.getDataSet().getString("poinconditionid") + " Pada No. Poin #" + poinRule.getDataSet().getString("PoinRuleNo") + " Tidak Ditemukan Pada Master Syarat Poin !", (Throwable)cause) : (errMsg.contains("fk_poinrule_relations_bpgrp") ? new BITSException("0", "Kode Grup Custromer #" + poinRule.getDataSet().getString("bpgrpid") + " Pada No. Poin #" + poinRule.getDataSet().getString("PoinRuleNo") + " Tidak Ditemukan Pada Master Grup Mitra Bisnis !", (Throwable)cause) : (errMsg.contains("fk_poinrule_relations_pointarget") ? new BITSException("0", "Kode Target Poin #" + poinRule.getDataSet().getString("pointargetid") + " Pada No. Poin #" + poinRule.getDataSet().getString("PoinRuleNo") + " Tidak Ditemukan Pada Master Target Poin !", (Throwable)cause) : (errMsg.contains("adding a row to the") && errMsg.contains("poinrule") && errMsg.contains("value too long for type character varying(15)") ? (poinRule.getDataSet().getString("poinruleno").length() > 15 ? new BITSException("0", "No. Poin #" + poinRule.getDataSet().getString("poinruleno") + " terlalu panjang, max 15 karakter !", (Throwable)cause) : new Exception(errMsg)) : (errMsg.contains("adding a row to the") && errMsg.contains("poinrule") && errMsg.contains("value too long for type character varying(30)") ? (poinRule.getDataSet().getString("poinruledesc").length() > 30 ? new BITSException("0", "Nama Poin #" + poinRule.getDataSet().getString("poinruledesc") + " pada transaksi #" + poinRule.getDataSet().getString("poinruleno") + " terlalu panjang, max 30 karakter !", (Throwable)cause) : new Exception(errMsg)) : (errMsg.contains("adding a row to the") && errMsg.contains("poinrule") && errMsg.contains("value too long for type character varying(10)") ? (poinRule.getDataSet().getString("bpgrpid").length() > 10 ? new BITSException("0", "Kode Grup Customer #" + poinRule.getDataSet().getString("bpgrpid") + " pada transaksi #" + poinRule.getDataSet().getString("poinruleno") + " terlalu panjang, max 10 karakter !", (Throwable)cause) : new Exception(errMsg)) : (errMsg.contains("adding a row to the") && errMsg.contains("poinrule") && errMsg.contains("value too long for type character varying(20)") ? (poinRule.getDataSet().getString("itemid").length() > 20 ? new BITSException("0", "Kode Item #" + poinRule.getDataSet().getString("itemid") + " pada transaksi #" + poinRule.getDataSet().getString("poinruleno") + " terlalu panjang, max 20 karakter !", (Throwable)cause) : new Exception(errMsg)) : (errMsg.contains("adding a row to the") && errMsg.contains("poinrule") && errMsg.contains("value too long for type character varying(5)") ? (poinRule.getDataSet().getString("crcid").length() > 5 ? new BITSException("0", "Kode Mata Uang #" + poinRule.getDataSet().getString("crcid") + " pada transaksi #" + poinRule.getDataSet().getString("poinruleno") + " terlalu panjang, max 5 karakter !", (Throwable)cause) : new Exception(errMsg)) : new Exception(errMsg)))))))))))));
        return ex;
    }

    private void writeErrorMessage(int rowno, Exception ex) {
        this.txtLog.append(String.format(this.l.getMessageUI(null, "ex.row"), rowno, BHelp.getExceptionDetail((Exception)ex)));
        logger.error(String.format(this.l.getMessageUI(null, "ex.row"), rowno, BHelp.getExceptionDetail((Exception)ex)));
        ++this.error;
    }

    private void refreshForm() {
        Component[] compPanel = this.jPanel1.getComponents();
        if (this.jPanelChooser1.getFileName() != null) {
            this.btnProcess.setEnabled(true);
        } else {
            this.btnProcess.setEnabled(false);
        }
        for (Component compPanel1 : compPanel) {
            if (!(compPanel1 instanceof JBdbComboBox)) continue;
            ((JBdbComboBox)compPanel1).setSelectedIndex(-1);
        }
        this.txtLog.setText(null);
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void initComponents() {
        this.jLabel20 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanelChooser1 = new JPanelChooser();
        this.btnProcess = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel5 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jcbPoinID = new JBdbComboBox();
        this.jcbPoinName = new JBdbComboBox();
        this.jcbActive = new JBdbComboBox();
        this.jcbMultiply = new JBdbComboBox();
        this.jcbMu = new JBdbComboBox();
        this.jcbTotalFaktur = new JBdbComboBox();
        this.jLabel17 = new JLabel();
        this.jcbCustGroup = new JBdbComboBox();
        this.jLabel19 = new JLabel();
        this.jcbTargetPoin = new JBdbComboBox();
        this.jLabel34 = new JLabel();
        this.jcbPeriodeStart = new JBdbComboBox();
        this.jLabel37 = new JLabel();
        this.jcbQtyPoin = new JBdbComboBox();
        this.jLabel35 = new JLabel();
        this.jcbPeriodeEnd = new JBdbComboBox();
        this.jLabel16 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.txtLog = new JTextArea();
        this.btnRefreshForm = new JButton();
        this.jPanel4 = new JPanel();
        this.btnDownloadXLS1 = new BtnDownloadXLS();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setTitle("Import Data Poin Rule Per Total Faktur | Poin Rule");
        this.jLabel20.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel20.setForeground(new Color(102, 102, 102));
        this.jLabel20.setText("IMPORT DATA POIN RULE PER TOTAL ITEM");
        this.jPanel3.setBackground(new Color(204, 204, 204));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanelChooser1.setBackground(new Color(204, 204, 204));
        this.btnProcess.setFont(new Font("Dialog", 1, 11));
        this.btnProcess.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/leftarror.png")));
        this.btnProcess.setText("Proses");
        this.btnProcess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPoinRuleImport.this.btnProcessActionPerformed(evt);
            }
        });
        this.jPanel5.setBackground(new Color(204, 204, 204));
        this.jPanel1.setBackground(new Color(204, 204, 204));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)), "XLS Column", 0, 0, new Font("Dialog", 1, 11)));
        this.jLabel2.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel2.setText("No. Poin:");
        this.jLabel3.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel3.setText("Nama Poin:");
        this.jLabel4.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel4.setText("Active:");
        this.jLabel5.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel5.setText("Kelipatan:");
        this.jLabel6.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel6.setText("Kode Mata Uang:");
        this.jLabel8.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel8.setText("Total Faktur:");
        this.jLabel17.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel17.setText("Kode Grup Customer *:");
        this.jLabel19.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel19.setText("Target Poin:");
        this.jLabel34.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel34.setText("Tanggal Awal *:");
        this.jLabel37.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel37.setText("Qty Poin:");
        this.jLabel35.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel35.setText("Tanggal Akhir *:");
        this.jLabel16.setFont(new Font("Dialog", 1, 11));
        this.jLabel16.setText("*) optional");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(20, 20, 20).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel34, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel35, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel37, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jcbActive, -2, 142, -2).addComponent((Component)this.jcbPoinID, -2, -1, -2).addComponent((Component)this.jcbPoinName, -2, 142, -2).addComponent((Component)this.jcbPeriodeStart, -2, -1, -2).addComponent((Component)this.jcbPeriodeEnd, -2, -1, -2).addComponent((Component)this.jcbQtyPoin, -2, -1, -2)).addGap(28, 28, 28).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel8).addComponent(this.jLabel19).addComponent(this.jLabel5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jcbTargetPoin, -2, -1, -2).addComponent((Component)this.jcbTotalFaktur, -2, 142, -2).addComponent((Component)this.jcbMu, -2, 142, -2).addComponent((Component)this.jcbMultiply, -2, 142, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel16).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jcbCustGroup, -2, 140, -2))).addGap(2, 2, 2))).addGap(25, 25, 25)));
        jPanel1Layout.linkSize(0, new Component[]{this.jcbActive, this.jcbMu, this.jcbMultiply, this.jcbPeriodeStart, this.jcbPoinID, this.jcbPoinName, this.jcbQtyPoin, this.jcbTotalFaktur});
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jcbPoinID, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent((Component)this.jcbPoinName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jcbPeriodeStart, -2, -1, -2).addComponent(this.jLabel34)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jcbPeriodeEnd, -2, -1, -2).addComponent(this.jLabel35))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent((Component)this.jcbMultiply, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent((Component)this.jcbMu, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent((Component)this.jcbTotalFaktur, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jcbTargetPoin, -2, -1, -2).addComponent(this.jLabel19)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jcbQtyPoin, -2, -1, -2).addComponent(this.jLabel37)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent((Component)this.jcbActive, -2, -1, -2))).addComponent(this.jLabel17).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.jcbCustGroup, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel16))).addContainerGap()));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Data", this.jPanel5);
        this.jPanel6.setBackground(new Color(204, 204, 204));
        this.txtLog.setColumns(20);
        this.txtLog.setRows(5);
        this.jScrollPane1.setViewportView(this.txtLog);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 563, Short.MAX_VALUE).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 201, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Log", this.jPanel6);
        this.btnRefreshForm.setFont(new Font("Dialog", 1, 11));
        this.btnRefreshForm.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/refresh.png")));
        this.btnRefreshForm.setText("Refresh");
        this.btnRefreshForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPoinRuleImport.this.btnRefreshFormActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(35, 35, 35).addComponent((Component)this.jPanelChooser1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnRefreshForm).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnProcess)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.jPanelChooser1, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnProcess, -1, -1, Short.MAX_VALUE).addComponent(this.btnRefreshForm))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1).addContainerGap()));
        this.btnDownloadXLS1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPoinRuleImport.this.btnDownloadXLS1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent((Component)this.btnDownloadXLS1, -2, -1, -2)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.btnDownloadXLS1, -2, -1, -2));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel20, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void btnRefreshFormActionPerformed(ActionEvent evt) {
        this.refreshForm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnProcessActionPerformed(ActionEvent evt) {
        try {
            ScreenManager.setCursorThinking((JInternalFrame)this);
            this.error = 0;
            this.success = 0;
            this.validateFilter();
            this.readData();
            this.txtLog.append(String.format(this.l.getMessageUI(null, "status.import.sum"), this.success, this.error));
            UIMgr.showMessageDialog((String)String.format(this.l.getMessageUI(null, "ok.import.sum"), this.success, this.error), (Component)this);
            this.btnProcess.setEnabled(false);
            this.jTabbedPane1.setSelectedIndex(1);
        }
        catch (LimitOverException loe) {
            UIMgr.showErrorDialog((String)this.l.getMessageUI(null, "ex.import"), (Exception)((Object)loe), (Component)this, (Logger)logger);
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)this.l.getMessageUI(null, "ex.import"), (Exception)ex, (Component)this, (Logger)logger);
        }
        finally {
            ScreenManager.setCursorDefault((JInternalFrame)this);
        }
    }

    private void btnDownloadXLS1ActionPerformed(ActionEvent evt) {
        try {
            HelpBrowseStarter.showHelpBrowser((String)"plugins/XlsPoinTotalFaktur/PoinRuleTotalFaktur.xls");
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)"Gagal menampilkan buku manual", (Exception)ex, (Logger)logger);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("filename")) {
            this.readFile();
            this.btnProcess.setEnabled(true);
            this.btnRefreshForm.setEnabled(true);
            BUtil.setEnabledJTabbedPane((JTabbedPane)this.jTabbedPane1, (boolean)true);
        }
    }
}

