/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.util.Date;

public final class ErrorManager {
    private static final ErrorManager INSTANCE = new ErrorManager();
    public static final int UNKNOWN = 0;
    public static final int INFORMATIONAL = 1;
    public static final int WARNING = 16;
    public static final int USER = 256;
    public static final int EXCEPTION = 4096;
    public static final int ERROR = 65536;

    public static ErrorManager getDefault() {
        return INSTANCE;
    }

    public Throwable annotate(Throwable t, int severity, String message, String localizedMessage, Throwable stackTrace, Date date) {
        if (stackTrace != null) {
            stackTrace.printStackTrace();
        }
        return stackTrace;
    }

    public void notify(int severity, Throwable t) {
        t.printStackTrace();
    }

    public final void notify(Throwable t) {
        this.notify(0, t);
    }

    public void log(int severity, String s) {
        System.err.println(s);
    }

    public final void log(String s) {
        this.log(1, s);
    }

    public boolean isLoggable(int severity) {
        return true;
    }

    public ErrorManager getInstance(String name) {
        return ErrorManager.getDefault();
    }

    public final Throwable annotate(Throwable t, String localizedMessage) {
        return this.annotate(t, 0, null, localizedMessage, null, null);
    }

    public final Throwable annotate(Throwable target, Throwable t) {
        return this.annotate(target, 0, null, null, t, null);
    }
}

